/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.lwjgl;

import com.badlogic.gdx.backends.lwjgl.LwjglApplicationConfiguration;
import com.badlogic.gdx.utils.GdxNativesLoader;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.SharedLibraryLoader;
import java.io.File;
import java.lang.reflect.Method;

public final class LwjglNativesLoader {
    public static boolean load = true;

    public static void load() {
        GdxNativesLoader.load();
        if (GdxNativesLoader.disableNativesLoading) {
            return;
        }
        if (!load) {
            return;
        }
        SharedLibraryLoader loader = new SharedLibraryLoader();
        File nativesDir = null;
        try {
            String lwjglLib = null;
            String openalLib = null;
            block1 : switch (SharedLibraryLoader.os) {
                case Windows: {
                    switch (SharedLibraryLoader.bitness) {
                        case _32: {
                            lwjglLib = "lwjgl.dll";
                            openalLib = "OpenAL32.dll";
                            break;
                        }
                        case _64: {
                            lwjglLib = "lwjgl64.dll";
                            openalLib = "OpenAL64.dll";
                        }
                    }
                    break;
                }
                case MacOsX: {
                    lwjglLib = "liblwjgl.dylib";
                    openalLib = "openal.dylib";
                    break;
                }
                case Linux: {
                    switch (SharedLibraryLoader.bitness) {
                        case _32: {
                            lwjglLib = "liblwjgl.so";
                            openalLib = "libopenal.so";
                            break block1;
                        }
                        case _64: {
                            lwjglLib = "liblwjgl64.so";
                            openalLib = "libopenal64.so";
                        }
                    }
                }
            }
            if (lwjglLib == null) {
                throw new GdxRuntimeException("Unknown LWJGL platform: " + (Object)((Object)SharedLibraryLoader.os) + ", " + (Object)((Object)SharedLibraryLoader.bitness));
            }
            nativesDir = loader.extractFile(lwjglLib, null).getParentFile();
            if (!LwjglApplicationConfiguration.disableAudio) {
                loader.extractFileTo(openalLib, nativesDir);
            }
        }
        catch (Throwable ex) {
            throw new GdxRuntimeException("Unable to extract LWJGL natives.", ex);
        }
        System.setProperty("org.lwjgl.librarypath", nativesDir.getAbsolutePath());
        load = false;
    }

    static {
        System.setProperty("org.lwjgl.input.Mouse.allowNegativeMouseCoords", "true");
        try {
            Method method = Class.forName("javax.jnlp.ServiceManager").getDeclaredMethod("lookup", String.class);
            method.invoke(null, "javax.jnlp.PersistenceService");
            load = false;
        }
        catch (Throwable ex) {
            load = true;
        }
    }
}

