/*
 * Decompiled with CFR 0.152.
 */
package com.kotcrab.vis.ui;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.kotcrab.vis.ui.Sizes;

public class VisUI {
    private static final String TARGET_GDX_VERSION = "1.10.0";
    private static boolean skipGdxVersionCheck = false;
    private static int defaultTitleAlign = 8;
    private static SkinScale scale;
    private static Skin skin;

    public static void load() {
        VisUI.load(SkinScale.X1);
    }

    public static void load(SkinScale scale) {
        VisUI.scale = scale;
        VisUI.load(scale.getSkinFile());
    }

    public static void load(String internalVisSkinPath) {
        VisUI.load(Gdx.files.internal(internalVisSkinPath));
    }

    public static void load(FileHandle visSkinFile) {
        VisUI.checkBeforeLoad();
        skin = new Skin(visSkinFile);
    }

    public static void load(Skin skin) {
        VisUI.checkBeforeLoad();
        VisUI.skin = skin;
    }

    private static void checkBeforeLoad() {
        if (skin != null) {
            throw new GdxRuntimeException("VisUI cannot be loaded twice");
        }
        if (!skipGdxVersionCheck && !TARGET_GDX_VERSION.equals(TARGET_GDX_VERSION)) {
            Gdx.app.log("VisUI", "Warning, using invalid libGDX version.\nYou are using libGDX 1.10.0 but you need 1.10.0. This may cause unexpected problems and runtime exceptions.");
        }
    }

    public static void dispose() {
        VisUI.dispose(true);
    }

    public static void dispose(boolean disposeSkin) {
        if (skin != null) {
            if (disposeSkin) {
                skin.dispose();
            }
            skin = null;
        }
    }

    public static Skin getSkin() {
        if (skin == null) {
            throw new IllegalStateException("VisUI is not loaded!");
        }
        return skin;
    }

    public static boolean isLoaded() {
        return skin != null;
    }

    public static Sizes getSizes() {
        if (scale == null) {
            return VisUI.getSkin().get(Sizes.class);
        }
        return VisUI.getSkin().get(scale.getSizesName(), Sizes.class);
    }

    public static int getDefaultTitleAlign() {
        return defaultTitleAlign;
    }

    public static void setDefaultTitleAlign(int defaultTitleAlign) {
        VisUI.defaultTitleAlign = defaultTitleAlign;
    }

    public static void setSkipGdxVersionCheck(boolean setSkipGdxVersionCheck) {
        skipGdxVersionCheck = setSkipGdxVersionCheck;
    }

    public static enum SkinScale {
        X1("com/kotcrab/vis/ui/skin/x1/uiskin.json", "default"),
        X2("com/kotcrab/vis/ui/skin/x2/uiskin.json", "x2");

        private final String classpath;
        private final String sizesName;

        private SkinScale(String classpath, String sizesName) {
            this.classpath = classpath;
            this.sizesName = sizesName;
        }

        public FileHandle getSkinFile() {
            return Gdx.files.classpath(this.classpath);
        }

        public String getSizesName() {
            return this.sizesName;
        }
    }
}

