/*
 * Decompiled with CFR 0.152.
 */
package com.kotcrab.vis.ui.util;

import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.WidgetGroup;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.ObjectMap;
import com.badlogic.gdx.utils.Timer;
import com.kotcrab.vis.ui.widget.VisTable;
import com.kotcrab.vis.ui.widget.toast.Toast;
import com.kotcrab.vis.ui.widget.toast.ToastTable;

public class ToastManager {
    public static final int UNTIL_CLOSED = -1;
    private final Group root;
    private int screenPaddingX = 20;
    private int screenPaddingY = 20;
    private int messagePadding = 5;
    private int alignment = 18;
    private Array<Toast> toasts = new Array();
    private ObjectMap<Toast, Timer.Task> timersTasks = new ObjectMap();

    public ToastManager(Stage stage) {
        WidgetGroup widgetGroup = new WidgetGroup();
        widgetGroup.setFillParent(true);
        widgetGroup.setTouchable(Touchable.childrenOnly);
        stage.addActor(widgetGroup);
        this.root = widgetGroup;
    }

    public ToastManager(Group root) {
        this.root = root;
    }

    public void show(String text) {
        this.show(text, -1.0f);
    }

    public void show(String text, float timeSec) {
        VisTable table = new VisTable();
        table.add(text).grow();
        this.show(table, timeSec);
    }

    public void show(Table table) {
        this.show(table, -1.0f);
    }

    public void show(Table table, float timeSec) {
        this.show(new Toast(table), timeSec);
    }

    public void show(ToastTable toastTable) {
        this.show(toastTable, -1.0f);
    }

    public void show(ToastTable toastTable, float timeSec) {
        Toast toast = toastTable.getToast();
        if (toast != null) {
            this.show(toast, timeSec);
        } else {
            this.show(new Toast(toastTable), timeSec);
        }
    }

    public void show(Toast toast) {
        this.show(toast, -1.0f);
    }

    public void show(final Toast toast, float timeSec) {
        Table toastMainTable = toast.getMainTable();
        if (toastMainTable.getStage() != null) {
            this.remove(toast);
        }
        this.toasts.add(toast);
        toast.setToastManager(this);
        toast.fadeIn();
        toastMainTable.pack();
        this.root.addActor(toastMainTable);
        this.updateToastsPositions();
        if (timeSec > 0.0f) {
            Timer.Task fadeOutTask = new Timer.Task(){

                @Override
                public void run() {
                    toast.fadeOut();
                    ToastManager.this.timersTasks.remove(toast);
                }
            };
            this.timersTasks.put(toast, fadeOutTask);
            Timer.schedule(fadeOutTask, timeSec);
        }
    }

    public void resize() {
        this.updateToastsPositions();
    }

    public boolean remove(Toast toast) {
        boolean removed = this.toasts.removeValue(toast, true);
        if (removed) {
            toast.getMainTable().remove();
            Timer.Task timerTask = this.timersTasks.remove(toast);
            if (timerTask != null) {
                timerTask.cancel();
            }
            this.updateToastsPositions();
        }
        return removed;
    }

    public void clear() {
        for (Toast toast : this.toasts) {
            toast.getMainTable().remove();
        }
        this.toasts.clear();
        for (Timer.Task task : this.timersTasks.values()) {
            task.cancel();
        }
        this.timersTasks.clear();
        this.updateToastsPositions();
    }

    public void toFront() {
        this.root.toFront();
    }

    private void updateToastsPositions() {
        boolean bottom = (this.alignment & 4) != 0;
        boolean left = (this.alignment & 8) != 0;
        float y = bottom ? (float)this.screenPaddingY : this.root.getHeight() - (float)this.screenPaddingY;
        for (Toast toast : this.toasts) {
            Table table = toast.getMainTable();
            table.setPosition(left ? (float)this.screenPaddingX : this.root.getWidth() - table.getWidth() - (float)this.screenPaddingX, bottom ? y : y - table.getHeight());
            y += (table.getHeight() + (float)this.messagePadding) * (float)(bottom ? 1 : -1);
        }
    }

    @Deprecated
    public int getScreenPadding() {
        if (this.screenPaddingX != this.screenPaddingY) {
            throw new IllegalStateException("Value of screen padding X is different than padding Y. Use either getScreenPaddingX or getScreenPaddingY.");
        }
        return this.screenPaddingX;
    }

    public int getScreenPaddingX() {
        return this.screenPaddingX;
    }

    public int getScreenPaddingY() {
        return this.screenPaddingY;
    }

    public void setScreenPadding(int screenPadding) {
        this.screenPaddingX = screenPadding;
        this.screenPaddingY = screenPadding;
        this.updateToastsPositions();
    }

    public void setScreenPadding(int screenPaddingX, int screenPaddingY) {
        this.screenPaddingX = screenPaddingX;
        this.screenPaddingY = screenPaddingY;
        this.updateToastsPositions();
    }

    public void setScreenPaddingX(int screenPaddingX) {
        this.screenPaddingX = screenPaddingX;
        this.updateToastsPositions();
    }

    public void setScreenPaddingY(int screenPaddingY) {
        this.screenPaddingY = screenPaddingY;
        this.updateToastsPositions();
    }

    public int getMessagePadding() {
        return this.messagePadding;
    }

    public void setMessagePadding(int messagePadding) {
        this.messagePadding = messagePadding;
        this.updateToastsPositions();
    }

    public int getAlignment() {
        return this.alignment;
    }

    public void setAlignment(int alignment) {
        this.alignment = alignment;
        this.updateToastsPositions();
    }
}

