/*
 * Decompiled with CFR 0.152.
 */
package com.kotcrab.vis.ui.widget;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.scenes.scene2d.ui.Widget;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.kotcrab.vis.ui.VisUI;

public class BusyBar
extends Widget {
    private BusyBarStyle style;
    private float segmentX;

    public BusyBar() {
        this.style = VisUI.getSkin().get(BusyBarStyle.class);
    }

    public BusyBar(String styleName) {
        this.style = VisUI.getSkin().get(styleName, BusyBarStyle.class);
    }

    public BusyBar(BusyBarStyle style) {
        this.style = style;
    }

    @Override
    public float getPrefHeight() {
        return this.style.height;
    }

    @Override
    public float getPrefWidth() {
        return this.style.segmentWidth;
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        batch.flush();
        if (this.clipBegin()) {
            Color c = this.getColor();
            batch.setColor(c.r, c.g, c.b, c.a * parentAlpha);
            this.segmentX += this.getSegmentDeltaX();
            this.style.segment.draw(batch, this.getX() + this.segmentX, this.getY(), this.style.segmentWidth, this.style.height);
            if (this.segmentX > this.getWidth() + (float)this.style.segmentOverflow) {
                this.resetSegment();
            }
            if (this.isVisible()) {
                Gdx.graphics.requestRendering();
            }
            batch.flush();
            this.clipEnd();
        }
    }

    public void resetSegment() {
        this.segmentX = -this.style.segmentWidth - this.style.segmentOverflow;
    }

    protected float getSegmentDeltaX() {
        return Gdx.graphics.getDeltaTime() * this.getWidth();
    }

    public BusyBarStyle getStyle() {
        return this.style;
    }

    public static class BusyBarStyle {
        public Drawable segment;
        public int segmentOverflow;
        public int segmentWidth;
        public int height;

        public BusyBarStyle() {
        }

        public BusyBarStyle(BusyBarStyle style) {
            this.segment = style.segment;
            this.segmentOverflow = style.segmentOverflow;
            this.segmentWidth = style.segmentWidth;
            this.height = style.height;
        }

        public BusyBarStyle(Drawable segment, int segmentOverflow, int segmentWidth, int height) {
            this.segment = segment;
            this.segmentOverflow = segmentOverflow;
            this.segmentWidth = segmentWidth;
            this.height = height;
        }
    }
}

