/*
 * Decompiled with CFR 0.152.
 */
package com.kotcrab.vis.ui.widget;

import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.actions.FloatAction;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.WidgetGroup;
import com.badlogic.gdx.utils.GdxRuntimeException;

public class HorizontalCollapsibleWidget
extends WidgetGroup {
    private Table table;
    private CollapseAction collapseAction = new CollapseAction();
    private float collapseDuration = 0.3f;
    private Interpolation collapseInterpolation = Interpolation.pow3Out;
    private boolean collapsed;
    private boolean actionRunning;
    private float currentWidth;

    public HorizontalCollapsibleWidget() {
    }

    public HorizontalCollapsibleWidget(Table table) {
        this(table, false);
    }

    public HorizontalCollapsibleWidget(Table table, boolean collapsed) {
        this.collapsed = collapsed;
        this.table = table;
        this.updateTouchable();
        if (table != null) {
            this.addActor(table);
        }
    }

    public void setCollapsed(boolean collapse, boolean withAnimation) {
        this.collapsed = collapse;
        this.updateTouchable();
        if (this.table == null) {
            return;
        }
        this.actionRunning = true;
        if (withAnimation) {
            this.collapseAction.reset();
            this.collapseAction.setStart(this.currentWidth);
            this.collapseAction.setEnd(collapse ? 0.0f : this.table.getPrefWidth());
            this.collapseAction.setDuration(this.collapseDuration);
            this.collapseAction.setInterpolation(this.collapseInterpolation);
            this.addAction(this.collapseAction);
        } else {
            if (collapse) {
                this.currentWidth = 0.0f;
                this.collapsed = true;
            } else {
                this.currentWidth = this.table.getPrefWidth();
                this.collapsed = false;
            }
            this.actionRunning = false;
            this.invalidateHierarchy();
        }
    }

    public void setCollapsed(boolean collapse) {
        this.setCollapsed(collapse, true);
    }

    public boolean isCollapsed() {
        return this.collapsed;
    }

    private void updateTouchable() {
        if (this.collapsed) {
            this.setTouchable(Touchable.disabled);
        } else {
            this.setTouchable(Touchable.enabled);
        }
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        if (this.currentWidth > 1.0f && this.getX() + this.currentWidth > 1.0f) {
            if (this.actionRunning) {
                batch.flush();
                boolean clipEnabled = this.clipBegin(this.getX(), this.getY(), this.currentWidth, this.getHeight());
                super.draw(batch, parentAlpha);
                batch.flush();
                if (clipEnabled) {
                    this.clipEnd();
                }
            } else {
                super.draw(batch, parentAlpha);
            }
        }
    }

    @Override
    public void layout() {
        if (this.table == null) {
            return;
        }
        this.table.setBounds(0.0f, 0.0f, this.table.getPrefWidth(), this.table.getPrefHeight());
        if (!this.actionRunning) {
            this.currentWidth = this.collapsed ? 0.0f : this.table.getPrefWidth();
        }
    }

    @Override
    public float getPrefHeight() {
        return this.table == null ? 0.0f : this.table.getPrefHeight();
    }

    @Override
    public float getPrefWidth() {
        if (this.table == null) {
            return 0.0f;
        }
        if (!this.actionRunning) {
            if (this.collapsed) {
                return 0.0f;
            }
            return this.table.getPrefWidth();
        }
        return this.currentWidth;
    }

    public void setTable(Table table) {
        this.table = table;
        this.clearChildren();
        this.addActor(table);
    }

    @Override
    protected void childrenChanged() {
        super.childrenChanged();
        if (this.getChildren().size > 1) {
            throw new GdxRuntimeException("Only one actor can be added to CollapsibleWidget");
        }
    }

    private class CollapseAction
    extends FloatAction {
        private CollapseAction() {
        }

        @Override
        protected void update(float percent) {
            super.update(percent);
            HorizontalCollapsibleWidget.this.currentWidth = this.getValue();
            if (percent == 1.0f) {
                HorizontalCollapsibleWidget.this.actionRunning = false;
                HorizontalCollapsibleWidget.this.collapsed = HorizontalCollapsibleWidget.this.currentWidth == 0.0f;
            }
            HorizontalCollapsibleWidget.this.invalidateHierarchy();
        }
    }
}

