/*
 * Decompiled with CFR 0.152.
 */
package com.kotcrab.vis.ui.widget;

import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.utils.Array;
import com.kotcrab.vis.ui.VisUI;
import com.kotcrab.vis.ui.widget.Menu;
import com.kotcrab.vis.ui.widget.VisTable;

public class MenuBar {
    private Table mainTable;
    private Table menuItems;
    private Menu currentMenu;
    private Array<Menu> menus = new Array();
    private MenuBarListener menuListener;

    public MenuBar() {
        this("default");
    }

    public MenuBar(String styleName) {
        this(VisUI.getSkin().get(styleName, MenuBarStyle.class));
    }

    public MenuBar(MenuBarStyle style) {
        this.menuItems = new VisTable();
        this.mainTable = new VisTable(){

            @Override
            protected void sizeChanged() {
                super.sizeChanged();
                MenuBar.this.closeMenu();
            }
        };
        this.mainTable.left();
        this.mainTable.add(this.menuItems);
        this.mainTable.setBackground(style.background);
    }

    public void addMenu(Menu menu) {
        this.menus.add(menu);
        menu.setMenuBar(this);
        this.menuItems.add(menu.getOpenButton());
    }

    public boolean removeMenu(Menu menu) {
        boolean removed = this.menus.removeValue(menu, true);
        if (removed) {
            menu.setMenuBar(null);
            this.menuItems.removeActor(menu.getOpenButton());
        }
        return removed;
    }

    public void insertMenu(int index, Menu menu) {
        this.menus.insert(index, menu);
        menu.setMenuBar(this);
        this.rebuild();
    }

    private void rebuild() {
        this.menuItems.clear();
        for (Menu menu : this.menus) {
            this.menuItems.add(menu.getOpenButton());
        }
    }

    public void closeMenu() {
        if (this.currentMenu != null) {
            this.currentMenu.deselectButton();
            this.currentMenu.remove();
            this.currentMenu = null;
        }
    }

    Menu getCurrentMenu() {
        return this.currentMenu;
    }

    void setCurrentMenu(Menu newMenu) {
        if (this.currentMenu == newMenu) {
            return;
        }
        if (this.currentMenu != null) {
            this.currentMenu.deselectButton();
            if (this.menuListener != null) {
                this.menuListener.menuClosed(this.currentMenu);
            }
        }
        if (newMenu != null) {
            newMenu.selectButton();
            if (this.menuListener != null) {
                this.menuListener.menuOpened(newMenu);
            }
        }
        this.currentMenu = newMenu;
    }

    public void setMenuListener(MenuBarListener menuListener) {
        this.menuListener = menuListener;
    }

    public Table getTable() {
        return this.mainTable;
    }

    public static interface MenuBarListener {
        public void menuOpened(Menu var1);

        public void menuClosed(Menu var1);
    }

    public static class MenuBarStyle {
        public Drawable background;

        public MenuBarStyle() {
        }

        public MenuBarStyle(MenuBarStyle style) {
            this.background = style.background;
        }

        public MenuBarStyle(Drawable background) {
            this.background = background;
        }
    }
}

