/*
 * Decompiled with CFR 0.152.
 */
package com.kotcrab.vis.ui.widget;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.ui.WidgetGroup;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.scenes.scene2d.utils.Layout;
import com.badlogic.gdx.scenes.scene2d.utils.ScissorStack;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.FloatArray;
import com.badlogic.gdx.utils.SnapshotArray;
import com.kotcrab.vis.ui.FocusManager;
import com.kotcrab.vis.ui.VisUI;
import com.kotcrab.vis.ui.widget.VisSplitPane;
import com.kotcrab.vis.ui.widget.internal.SplitPaneCursorManager;
import java.util.Arrays;

public class MultiSplitPane
extends WidgetGroup {
    private MultiSplitPaneStyle style;
    private boolean vertical;
    private Array<Rectangle> widgetBounds = new Array();
    private Array<Rectangle> scissors = new Array();
    private Array<Rectangle> handleBounds = new Array();
    private FloatArray splits = new FloatArray();
    private Vector2 handlePosition = new Vector2();
    private Vector2 lastPoint = new Vector2();
    private Rectangle handleOver;
    private int handleOverIndex;

    public MultiSplitPane(boolean vertical) {
        this(vertical, "default-" + (vertical ? "vertical" : "horizontal"));
    }

    public MultiSplitPane(boolean vertical, String styleName) {
        this(vertical, VisUI.getSkin().get(styleName, MultiSplitPaneStyle.class));
    }

    public MultiSplitPane(boolean vertical, MultiSplitPaneStyle style) {
        this.vertical = vertical;
        this.setStyle(style);
        this.setSize(this.getPrefWidth(), this.getPrefHeight());
        this.initialize();
    }

    private void initialize() {
        this.addListener(new SplitPaneCursorManager(this, this.vertical){

            @Override
            protected boolean handleBoundsContains(float x, float y) {
                return MultiSplitPane.this.getHandleContaining(x, y) != null;
            }

            @Override
            protected boolean contains(float x, float y) {
                for (Rectangle bound : MultiSplitPane.this.widgetBounds) {
                    if (!bound.contains(x, y)) continue;
                    return true;
                }
                return MultiSplitPane.this.getHandleContaining(x, y) != null;
            }
        });
        this.addListener(new InputListener(){
            int draggingPointer = -1;

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                if (!MultiSplitPane.this.isTouchable()) {
                    return false;
                }
                if (this.draggingPointer != -1) {
                    return false;
                }
                if (pointer == 0 && button != 0) {
                    return false;
                }
                Rectangle containingHandle = MultiSplitPane.this.getHandleContaining(x, y);
                if (containingHandle != null) {
                    MultiSplitPane.this.handleOverIndex = MultiSplitPane.this.handleBounds.indexOf(containingHandle, true);
                    FocusManager.resetFocus(MultiSplitPane.this.getStage());
                    this.draggingPointer = pointer;
                    MultiSplitPane.this.lastPoint.set(x, y);
                    MultiSplitPane.this.handlePosition.set(containingHandle.x, containingHandle.y);
                    return true;
                }
                return false;
            }

            @Override
            public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                if (pointer == this.draggingPointer) {
                    this.draggingPointer = -1;
                }
                MultiSplitPane.this.handleOver = MultiSplitPane.this.getHandleContaining(x, y);
            }

            @Override
            public boolean mouseMoved(InputEvent event, float x, float y) {
                MultiSplitPane.this.handleOver = MultiSplitPane.this.getHandleContaining(x, y);
                return false;
            }

            @Override
            public void touchDragged(InputEvent event, float x, float y, int pointer) {
                if (pointer != this.draggingPointer) {
                    return;
                }
                Drawable handle = ((MultiSplitPane)MultiSplitPane.this).style.handle;
                if (!MultiSplitPane.this.vertical) {
                    float dragX;
                    float delta = x - ((MultiSplitPane)MultiSplitPane.this).lastPoint.x;
                    float availWidth = MultiSplitPane.this.getWidth() - handle.getMinWidth();
                    ((MultiSplitPane)MultiSplitPane.this).handlePosition.x = dragX = ((MultiSplitPane)MultiSplitPane.this).handlePosition.x + delta;
                    dragX = Math.max(0.0f, dragX);
                    dragX = Math.min(availWidth, dragX);
                    float targetSplit = dragX / availWidth;
                    MultiSplitPane.this.setSplit(MultiSplitPane.this.handleOverIndex, targetSplit);
                    MultiSplitPane.this.lastPoint.set(x, y);
                } else {
                    float dragY;
                    float delta = y - ((MultiSplitPane)MultiSplitPane.this).lastPoint.y;
                    float availHeight = MultiSplitPane.this.getHeight() - handle.getMinHeight();
                    ((MultiSplitPane)MultiSplitPane.this).handlePosition.y = dragY = ((MultiSplitPane)MultiSplitPane.this).handlePosition.y + delta;
                    dragY = Math.max(0.0f, dragY);
                    dragY = Math.min(availHeight, dragY);
                    float targetSplit = 1.0f - dragY / availHeight;
                    MultiSplitPane.this.setSplit(MultiSplitPane.this.handleOverIndex, targetSplit);
                    MultiSplitPane.this.lastPoint.set(x, y);
                }
                MultiSplitPane.this.invalidate();
            }
        });
    }

    private Rectangle getHandleContaining(float x, float y) {
        for (Rectangle rect : this.handleBounds) {
            if (!rect.contains(x, y)) continue;
            return rect;
        }
        return null;
    }

    public MultiSplitPaneStyle getStyle() {
        return this.style;
    }

    public void setStyle(MultiSplitPaneStyle style) {
        this.style = style;
        this.invalidateHierarchy();
    }

    @Override
    public void layout() {
        if (!this.vertical) {
            this.calculateHorizBoundsAndPositions();
        } else {
            this.calculateVertBoundsAndPositions();
        }
        SnapshotArray<Actor> actors = this.getChildren();
        for (int i = 0; i < actors.size; ++i) {
            Actor actor = (Actor)actors.get(i);
            Rectangle bounds = this.widgetBounds.get(i);
            actor.setBounds(bounds.x, bounds.y, bounds.width, bounds.height);
            if (!(actor instanceof Layout)) continue;
            ((Layout)((Object)actor)).validate();
        }
    }

    @Override
    public float getPrefWidth() {
        float width = 0.0f;
        for (Actor actor : this.getChildren()) {
            width = actor instanceof Layout ? ((Layout)((Object)actor)).getPrefWidth() : actor.getWidth();
        }
        if (!this.vertical) {
            width += (float)this.handleBounds.size * this.style.handle.getMinWidth();
        }
        return width;
    }

    @Override
    public float getPrefHeight() {
        float height = 0.0f;
        for (Actor actor : this.getChildren()) {
            height = actor instanceof Layout ? ((Layout)((Object)actor)).getPrefHeight() : actor.getHeight();
        }
        if (this.vertical) {
            height += (float)this.handleBounds.size * this.style.handle.getMinHeight();
        }
        return height;
    }

    @Override
    public float getMinWidth() {
        return 0.0f;
    }

    @Override
    public float getMinHeight() {
        return 0.0f;
    }

    public void setVertical(boolean vertical) {
        this.vertical = vertical;
    }

    private void calculateHorizBoundsAndPositions() {
        float height = this.getHeight();
        float width = this.getWidth();
        float handleWidth = this.style.handle.getMinWidth();
        float availWidth = width - (float)this.handleBounds.size * handleWidth;
        float areaUsed = 0.0f;
        float currentX = 0.0f;
        for (int i = 0; i < this.splits.size; ++i) {
            float areaWidthFromLeft = (int)(availWidth * this.splits.get(i));
            float areaWidth = areaWidthFromLeft - areaUsed;
            areaUsed += areaWidth;
            this.widgetBounds.get(i).set(currentX, 0.0f, areaWidth, height);
            this.handleBounds.get(i).set(currentX += areaWidth, 0.0f, handleWidth, height);
            currentX += handleWidth;
        }
        if (this.widgetBounds.size != 0) {
            this.widgetBounds.peek().set(currentX, 0.0f, availWidth - areaUsed, height);
        }
    }

    private void calculateVertBoundsAndPositions() {
        float width = this.getWidth();
        float height = this.getHeight();
        float handleHeight = this.style.handle.getMinHeight();
        float availHeight = height - (float)this.handleBounds.size * handleHeight;
        float areaUsed = 0.0f;
        float currentY = height;
        for (int i = 0; i < this.splits.size; ++i) {
            float areaHeightFromTop = (int)(availHeight * this.splits.get(i));
            float areaHeight = areaHeightFromTop - areaUsed;
            areaUsed += areaHeight;
            this.widgetBounds.get(i).set(0.0f, currentY - areaHeight, width, areaHeight);
            this.handleBounds.get(i).set(0.0f, (currentY -= areaHeight) - handleHeight, width, handleHeight);
            currentY -= handleHeight;
        }
        if (this.widgetBounds.size != 0) {
            this.widgetBounds.peek().set(0.0f, 0.0f, width, availHeight - areaUsed);
        }
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        this.validate();
        Color color = this.getColor();
        this.applyTransform(batch, this.computeTransform());
        SnapshotArray<Actor> actors = this.getChildren();
        for (int i = 0; i < actors.size; ++i) {
            Actor actor = (Actor)actors.get(i);
            Rectangle bounds = this.widgetBounds.get(i);
            Rectangle scissor = this.scissors.get(i);
            this.getStage().calculateScissors(bounds, scissor);
            if (!ScissorStack.pushScissors(scissor)) continue;
            if (actor.isVisible()) {
                actor.draw(batch, parentAlpha * color.a);
            }
            batch.flush();
            ScissorStack.popScissors();
        }
        batch.setColor(color.r, color.g, color.b, parentAlpha * color.a);
        Drawable handle = this.style.handle;
        Drawable handleOver = this.style.handle;
        if (this.isTouchable() && this.style.handleOver != null) {
            handleOver = this.style.handleOver;
        }
        for (Rectangle rect : this.handleBounds) {
            if (this.handleOver == rect) {
                handleOver.draw(batch, rect.x, rect.y, rect.width, rect.height);
                continue;
            }
            handle.draw(batch, rect.x, rect.y, rect.width, rect.height);
        }
        this.resetTransform(batch);
    }

    @Override
    public Actor hit(float x, float y, boolean touchable) {
        if (touchable && this.getTouchable() == Touchable.disabled) {
            return null;
        }
        if (this.getHandleContaining(x, y) != null) {
            return this;
        }
        return super.hit(x, y, touchable);
    }

    public void setWidgets(Actor ... actors) {
        this.setWidgets(Arrays.asList(actors));
    }

    public void setWidgets(Iterable<Actor> actors) {
        this.clearChildren();
        this.widgetBounds.clear();
        this.scissors.clear();
        this.handleBounds.clear();
        this.splits.clear();
        for (Actor actor : actors) {
            super.addActor(actor);
            this.widgetBounds.add(new Rectangle());
            this.scissors.add(new Rectangle());
        }
        float currentSplit = 0.0f;
        float splitAdvance = 1.0f / (float)this.getChildren().size;
        for (int i = 0; i < this.getChildren().size - 1; ++i) {
            this.handleBounds.add(new Rectangle());
            this.splits.add(currentSplit += splitAdvance);
        }
        this.invalidate();
    }

    public void setSplit(int handleBarIndex, float split) {
        if (handleBarIndex < 0) {
            throw new IllegalStateException("handleBarIndex can't be < 0");
        }
        if (handleBarIndex >= this.splits.size) {
            throw new IllegalStateException("handleBarIndex can't be >= splits size");
        }
        float minSplit = handleBarIndex == 0 ? 0.0f : this.splits.get(handleBarIndex - 1);
        float maxSplit = handleBarIndex == this.splits.size - 1 ? 1.0f : this.splits.get(handleBarIndex + 1);
        split = MathUtils.clamp(split, minSplit, maxSplit);
        this.splits.set(handleBarIndex, split);
    }

    @Override
    public void addActorAfter(Actor actorAfter, Actor actor) {
        throw new UnsupportedOperationException("Use MultiSplitPane#setWidgets");
    }

    @Override
    public void addActor(Actor actor) {
        throw new UnsupportedOperationException("Use MultiSplitPane#setWidgets");
    }

    @Override
    public void addActorAt(int index, Actor actor) {
        throw new UnsupportedOperationException("Use MultiSplitPane#setWidgets");
    }

    @Override
    public void addActorBefore(Actor actorBefore, Actor actor) {
        throw new UnsupportedOperationException("Use MultiSplitPane#setWidgets");
    }

    @Override
    public boolean removeActor(Actor actor) {
        throw new UnsupportedOperationException("Use MultiSplitPane#setWidgets");
    }

    public static class MultiSplitPaneStyle
    extends VisSplitPane.VisSplitPaneStyle {
        public MultiSplitPaneStyle() {
        }

        public MultiSplitPaneStyle(VisSplitPane.VisSplitPaneStyle style) {
            super(style);
        }

        public MultiSplitPaneStyle(Drawable handle, Drawable handleOver) {
            super(handle, handleOver);
        }
    }
}

