/*
 * Decompiled with CFR 0.152.
 */
package com.kotcrab.vis.ui.widget;

import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.utils.SnapshotArray;
import com.kotcrab.vis.ui.Sizes;
import com.kotcrab.vis.ui.VisUI;
import com.kotcrab.vis.ui.util.ActorUtils;
import com.kotcrab.vis.ui.widget.MenuItem;
import com.kotcrab.vis.ui.widget.Separator;

public class PopupMenu
extends Table {
    private static final Vector2 tmpVector = new Vector2();
    private Sizes sizes;
    private PopupMenuStyle style;
    private PopupMenuListener listener;
    private InputListener stageListener;
    private InputListener sharedMenuItemInputListener;
    private ChangeListener sharedMenuItemChangeListener;
    private InputListener defaultInputListener;
    private PopupMenu parentSubMenu;
    private PopupMenu activeSubMenu;
    private MenuItem activeItem;

    public PopupMenu() {
        this("default");
    }

    public PopupMenu(String styleName) {
        this(VisUI.getSkin().get(styleName, PopupMenuStyle.class));
    }

    public PopupMenu(PopupMenuStyle style) {
        this(VisUI.getSizes(), style);
    }

    public PopupMenu(Sizes sizes, PopupMenuStyle style) {
        this.sizes = sizes;
        this.style = style;
        this.setTouchable(Touchable.enabled);
        this.pad(0.0f);
        this.setBackground(style.background);
        this.createListeners();
    }

    public static void removeEveryMenu(Stage stage) {
        for (Actor actor : stage.getActors()) {
            if (!(actor instanceof PopupMenu)) continue;
            PopupMenu menu = (PopupMenu)actor;
            menu.removeHierarchy();
        }
    }

    private void createListeners() {
        this.stageListener = new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                if (!PopupMenu.this.getRootMenu().subMenuStructureContains(x, y)) {
                    PopupMenu.this.remove();
                }
                return true;
            }

            @Override
            public boolean keyDown(InputEvent event, int keycode) {
                SnapshotArray<Actor> children = PopupMenu.this.getChildren();
                if (children.size == 0 || PopupMenu.this.activeSubMenu != null) {
                    return false;
                }
                if (keycode == 20) {
                    PopupMenu.this.selectNextItem();
                    return true;
                }
                if (keycode == 19) {
                    PopupMenu.this.selectPreviousItem();
                    return true;
                }
                if (PopupMenu.this.activeItem == null) {
                    return false;
                }
                if (keycode == 21 && ((PopupMenu)PopupMenu.this).activeItem.containerMenu.parentSubMenu != null) {
                    ((PopupMenu)PopupMenu.this).activeItem.containerMenu.parentSubMenu.setActiveSubMenu(null);
                    return true;
                }
                if (keycode == 22 && PopupMenu.this.activeItem.getSubMenu() != null) {
                    PopupMenu.this.activeItem.showSubMenu();
                    PopupMenu.this.activeSubMenu.selectNextItem();
                    return true;
                }
                if (keycode == 66) {
                    PopupMenu.this.activeItem.fireChangeEvent();
                    return true;
                }
                return false;
            }
        };
        this.sharedMenuItemInputListener = new InputListener(){

            @Override
            public void enter(InputEvent event, float x, float y, int pointer, Actor fromActor) {
                MenuItem item;
                if (pointer == -1 && event.getListenerActor() instanceof MenuItem && !(item = (MenuItem)event.getListenerActor()).isDisabled()) {
                    PopupMenu.this.setActiveItem(item, false);
                }
            }

            @Override
            public void exit(InputEvent event, float x, float y, int pointer, Actor toActor) {
                if (pointer == -1 && event.getListenerActor() instanceof MenuItem) {
                    if (PopupMenu.this.activeSubMenu != null) {
                        return;
                    }
                    MenuItem item = (MenuItem)event.getListenerActor();
                    if (item == PopupMenu.this.activeItem) {
                        PopupMenu.this.setActiveItem(null, false);
                    }
                }
            }
        };
        this.sharedMenuItemChangeListener = new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                if (!event.isStopped()) {
                    PopupMenu.this.removeHierarchy();
                }
            }
        };
    }

    private PopupMenu getRootMenu() {
        if (this.parentSubMenu != null) {
            return this.parentSubMenu.getRootMenu();
        }
        return this;
    }

    private boolean subMenuStructureContains(float x, float y) {
        if (this.contains(x, y)) {
            return true;
        }
        if (this.activeSubMenu != null) {
            return this.activeSubMenu.subMenuStructureContains(x, y);
        }
        return false;
    }

    private void removeHierarchy() {
        if (this.activeItem != null && this.activeItem.containerMenu != null && this.activeItem.containerMenu.parentSubMenu != null) {
            this.activeItem.containerMenu.parentSubMenu.removeHierarchy();
        }
        this.remove();
    }

    private void selectNextItem() {
        Actor actor;
        int startIndex;
        SnapshotArray<Actor> children = this.getChildren();
        if (!this.hasSelectableMenuItems()) {
            return;
        }
        int i = startIndex = this.activeItem == null ? 0 : children.indexOf(this.activeItem, true) + 1;
        while (true) {
            if (i >= children.size) {
                i = 0;
            }
            if ((actor = (Actor)children.get(i)) instanceof MenuItem && !((MenuItem)actor).isDisabled()) break;
            ++i;
        }
        this.setActiveItem((MenuItem)actor, true);
    }

    private void selectPreviousItem() {
        Actor actor;
        int startIndex;
        SnapshotArray<Actor> children = this.getChildren();
        if (!this.hasSelectableMenuItems()) {
            return;
        }
        int i = startIndex = this.activeItem == null ? children.size - 1 : children.indexOf(this.activeItem, true) - 1;
        while (true) {
            if (i <= -1) {
                i = children.size - 1;
            }
            if ((actor = (Actor)children.get(i)) instanceof MenuItem && !((MenuItem)actor).isDisabled()) break;
            --i;
        }
        this.setActiveItem((MenuItem)actor, true);
    }

    private boolean hasSelectableMenuItems() {
        SnapshotArray<Actor> children = this.getChildren();
        for (Actor actor : children) {
            if (!(actor instanceof MenuItem) || ((MenuItem)actor).isDisabled()) continue;
            return true;
        }
        return false;
    }

    @Override
    public <T extends Actor> Cell<T> add(T actor) {
        if (actor instanceof MenuItem) {
            throw new IllegalArgumentException("MenuItems can be only added to PopupMenu by using addItem(MenuItem) method");
        }
        return super.add(actor);
    }

    public void addItem(MenuItem item) {
        super.add(item).fillX().expandX().row();
        this.pack();
        item.addListener(this.sharedMenuItemChangeListener);
        item.addListener(this.sharedMenuItemInputListener);
    }

    public void addSeparator() {
        this.add((T)new Separator("menu")).padTop(2.0f).padBottom(2.0f).fill().expand().row();
    }

    public InputListener getDefaultInputListener() {
        return this.getDefaultInputListener(1);
    }

    public InputListener getDefaultInputListener(final int mouseButton) {
        if (this.defaultInputListener == null) {
            this.defaultInputListener = new InputListener(){

                @Override
                public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                    return true;
                }

                @Override
                public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                    if (event.getButton() == mouseButton) {
                        PopupMenu.this.showMenu(event.getStage(), event.getStageX(), event.getStageY());
                    }
                }
            };
        }
        return this.defaultInputListener;
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        super.draw(batch, parentAlpha);
        if (this.style.border != null) {
            this.style.border.draw(batch, this.getX(), this.getY(), this.getWidth(), this.getHeight());
        }
    }

    public void showMenu(Stage stage, float x, float y) {
        this.setPosition(x, y - this.getHeight());
        if (stage.getHeight() - this.getY() > stage.getHeight()) {
            this.setY(this.getY() + this.getHeight());
        }
        ActorUtils.keepWithinStage(stage, this);
        stage.addActor(this);
    }

    public void showMenu(Stage stage, Actor actor) {
        Vector2 pos = actor.localToStageCoordinates(tmpVector.setZero());
        float menuY = pos.y - this.getHeight() <= 0.0f ? pos.y + actor.getHeight() + this.getHeight() - this.sizes.borderSize : pos.y + this.sizes.borderSize;
        this.showMenu(stage, pos.x, menuY);
    }

    public boolean contains(float x, float y) {
        return this.getX() < x && this.getX() + this.getWidth() > x && this.getY() < y && this.getY() + this.getHeight() > y;
    }

    void setActiveSubMenu(PopupMenu newSubMenu) {
        if (this.activeSubMenu == newSubMenu) {
            return;
        }
        if (this.activeSubMenu != null) {
            this.activeSubMenu.remove();
        }
        this.activeSubMenu = newSubMenu;
        if (newSubMenu != null) {
            newSubMenu.setParentMenu(this);
        }
    }

    public PopupMenu getActiveSubMenu() {
        return this.activeSubMenu;
    }

    @Override
    protected void setStage(Stage stage) {
        super.setStage(stage);
        if (stage != null) {
            stage.addListener(this.stageListener);
        }
    }

    @Override
    public boolean remove() {
        if (this.getStage() != null) {
            this.getStage().removeListener(this.stageListener);
        }
        if (this.activeSubMenu != null) {
            this.activeSubMenu.remove();
        }
        this.setActiveItem(null, false);
        this.parentSubMenu = null;
        this.activeSubMenu = null;
        return super.remove();
    }

    void setActiveItem(MenuItem newItem, boolean keyboardChange) {
        this.activeItem = newItem;
        if (this.listener != null) {
            this.listener.activeItemChanged(newItem, keyboardChange);
        }
    }

    public MenuItem getActiveItem() {
        return this.activeItem;
    }

    void setParentMenu(PopupMenu parentSubMenu) {
        this.parentSubMenu = parentSubMenu;
    }

    public PopupMenuListener getListener() {
        return this.listener;
    }

    public void setListener(PopupMenuListener listener) {
        this.listener = listener;
    }

    public static class PopupMenuStyle {
        public Drawable background;
        public Drawable border;

        public PopupMenuStyle() {
        }

        public PopupMenuStyle(Drawable background, Drawable border) {
            this.background = background;
            this.border = border;
        }

        public PopupMenuStyle(PopupMenuStyle style) {
            this.background = style.background;
            this.border = style.border;
        }
    }

    public static interface PopupMenuListener {
        public void activeItemChanged(MenuItem var1, boolean var2);
    }
}

