/*
 * Decompiled with CFR 0.152.
 */
package com.kotcrab.vis.ui.widget;

import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.kotcrab.vis.ui.FocusManager;
import com.kotcrab.vis.ui.Focusable;
import com.kotcrab.vis.ui.VisUI;
import com.kotcrab.vis.ui.util.BorderOwner;

public class VisTextButton
extends TextButton
implements Focusable,
BorderOwner {
    private VisTextButtonStyle style;
    private boolean drawBorder;
    private boolean focusBorderEnabled = true;

    public VisTextButton(String text, String styleName) {
        super(text, VisUI.getSkin().get(styleName, VisTextButtonStyle.class));
        this.init();
    }

    public VisTextButton(String text) {
        super(text, VisUI.getSkin().get(VisTextButtonStyle.class));
        this.init();
    }

    public VisTextButton(String text, ChangeListener listener) {
        super(text, VisUI.getSkin().get(VisTextButtonStyle.class));
        this.init();
        this.addListener(listener);
    }

    public VisTextButton(String text, String styleName, ChangeListener listener) {
        super(text, VisUI.getSkin().get(styleName, VisTextButtonStyle.class));
        this.init();
        this.addListener(listener);
    }

    public VisTextButton(String text, VisTextButtonStyle buttonStyle) {
        super(text, buttonStyle);
        this.init();
    }

    private void init() {
        this.style = (VisTextButtonStyle)this.getStyle();
        this.addListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                if (!VisTextButton.this.isDisabled()) {
                    FocusManager.switchFocus(VisTextButton.this.getStage(), VisTextButton.this);
                }
                return false;
            }
        });
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        super.draw(batch, parentAlpha);
        if (this.focusBorderEnabled && this.drawBorder && this.style.focusBorder != null) {
            this.style.focusBorder.draw(batch, this.getX(), this.getY(), this.getWidth(), this.getHeight());
        }
    }

    @Override
    public boolean isFocusBorderEnabled() {
        return this.focusBorderEnabled;
    }

    @Override
    public void setFocusBorderEnabled(boolean focusBorderEnabled) {
        this.focusBorderEnabled = focusBorderEnabled;
    }

    @Override
    public void focusLost() {
        this.drawBorder = false;
    }

    @Override
    public void focusGained() {
        this.drawBorder = true;
    }

    public static class VisTextButtonStyle
    extends TextButton.TextButtonStyle {
        public Drawable focusBorder;

        public VisTextButtonStyle() {
        }

        public VisTextButtonStyle(Drawable up, Drawable down, Drawable checked, BitmapFont font) {
            super(up, down, checked, font);
        }

        public VisTextButtonStyle(VisTextButtonStyle style) {
            super(style);
            this.focusBorder = style.focusBorder;
        }
    }
}

