/*
 * Decompiled with CFR 0.152.
 */
package com.kotcrab.vis.ui.widget.color.internal;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.kotcrab.vis.ui.Sizes;
import com.kotcrab.vis.ui.widget.VisLabel;
import com.kotcrab.vis.ui.widget.VisTable;
import com.kotcrab.vis.ui.widget.color.ColorPickerWidgetStyle;
import com.kotcrab.vis.ui.widget.color.internal.AlphaChannelBar;
import com.kotcrab.vis.ui.widget.color.internal.ChannelBar;
import com.kotcrab.vis.ui.widget.color.internal.ColorInputField;
import com.kotcrab.vis.ui.widget.color.internal.PickerCommons;

public class ColorChannelWidget
extends VisTable {
    private PickerCommons commons;
    private ColorPickerWidgetStyle style;
    private Sizes sizes;
    private ChannelBar bar;
    private ChangeListener barListener;
    private ColorInputField inputField;
    private int mode;
    private int value;
    private int maxValue;

    public ColorChannelWidget(PickerCommons commons, String label, int mode, int maxValue, final ChannelBar.ChannelBarListener listener) {
        super(true);
        this.commons = commons;
        this.style = commons.style;
        this.sizes = commons.sizes;
        this.mode = mode;
        this.maxValue = maxValue;
        this.barListener = new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                ColorChannelWidget.this.value = ColorChannelWidget.this.bar.getValue();
                listener.updateFields();
                ColorChannelWidget.this.inputField.setValue(ColorChannelWidget.this.value);
            }
        };
        this.add(new VisLabel(label)).width(10.0f * this.sizes.scaleFactor).center();
        this.inputField = new ColorInputField(maxValue, new ColorInputField.ColorInputFieldListener(){

            @Override
            public void changed(int newValue) {
                ColorChannelWidget.this.value = newValue;
                listener.updateFields();
                ColorChannelWidget.this.bar.setValue(newValue);
            }
        });
        this.add(this.inputField).width(50.0f * this.sizes.scaleFactor);
        this.bar = this.createBarImage();
        this.add(this.bar).size(130.0f * this.sizes.scaleFactor, 12.0f * this.sizes.scaleFactor);
        this.bar.setChannelBarListener(listener);
        this.inputField.setValue(0);
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int value) {
        this.value = value;
        this.inputField.setValue(value);
        this.bar.setValue(value);
    }

    private ChannelBar createBarImage() {
        if (this.mode == 0) {
            return new AlphaChannelBar(this.commons, this.mode, this.maxValue, this.barListener);
        }
        return new ChannelBar(this.commons, this.mode, this.maxValue, this.barListener);
    }

    public ChannelBar getBar() {
        return this.bar;
    }

    public boolean isInputValid() {
        return this.inputField.isInputValid();
    }
}

