/*
 * Decompiled with CFR 0.152.
 */
package com.kotcrab.vis.ui.widget.color.internal;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import com.badlogic.gdx.utils.Disposable;
import com.kotcrab.vis.ui.Sizes;
import com.kotcrab.vis.ui.widget.color.ColorPickerWidgetStyle;

public class PickerCommons
implements Disposable {
    final ColorPickerWidgetStyle style;
    final Sizes sizes;
    private boolean loadExtendedShaders;
    ShaderProgram paletteShader;
    ShaderProgram verticalChannelShader;
    ShaderProgram hsvShader;
    ShaderProgram rgbShader;
    ShaderProgram gridShader;
    Texture whiteTexture;

    public PickerCommons(ColorPickerWidgetStyle style, Sizes sizes, boolean loadExtendedShaders) {
        this.style = style;
        this.sizes = sizes;
        this.loadExtendedShaders = loadExtendedShaders;
        this.createPixmap();
        this.loadShaders();
    }

    private void createPixmap() {
        Pixmap whitePixmap = new Pixmap(2, 2, Pixmap.Format.RGB888);
        whitePixmap.setColor(Color.WHITE);
        whitePixmap.drawRectangle(0, 0, 2, 2);
        this.whiteTexture = new Texture(whitePixmap);
        this.whiteTexture.setWrap(Texture.TextureWrap.Repeat, Texture.TextureWrap.Repeat);
        whitePixmap.dispose();
    }

    private void loadShaders() {
        this.paletteShader = this.loadShader("default.vert", "palette.frag");
        this.verticalChannelShader = this.loadShader("default.vert", "verticalBar.frag");
        this.gridShader = this.loadShader("default.vert", "checkerboard.frag");
        if (this.loadExtendedShaders) {
            this.hsvShader = this.loadShader("default.vert", "hsv.frag");
            this.rgbShader = this.loadShader("default.vert", "rgb.frag");
        }
    }

    private ShaderProgram loadShader(String vertFile, String fragFile) {
        ShaderProgram program = new ShaderProgram(Gdx.files.classpath("com/kotcrab/vis/ui/widget/color/internal/" + vertFile), Gdx.files.classpath("com/kotcrab/vis/ui/widget/color/internal/" + fragFile));
        if (!program.isCompiled()) {
            throw new IllegalStateException("ColorPicker shader compilation failed. Shader: " + vertFile + ", " + fragFile + ": " + program.getLog());
        }
        return program;
    }

    ShaderProgram getBarShader(int mode) {
        switch (mode) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return this.rgbShader;
            }
            case 4: 
            case 5: 
            case 6: {
                return this.hsvShader;
            }
        }
        throw new IllegalStateException("Unsupported mode: " + mode);
    }

    @Override
    public void dispose() {
        this.whiteTexture.dispose();
        this.paletteShader.dispose();
        this.verticalChannelShader.dispose();
        this.gridShader.dispose();
        if (this.loadExtendedShaders) {
            this.hsvShader.dispose();
            this.rgbShader.dispose();
        }
    }
}

