/*
 * Decompiled with CFR 0.152.
 */
package com.kotcrab.vis.ui.widget.internal;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Cursor;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.kotcrab.vis.ui.util.CursorManager;

public abstract class SplitPaneCursorManager
extends ClickListener {
    private Actor owner;
    private boolean vertical;
    private Cursor.SystemCursor currentCursor;

    public SplitPaneCursorManager(Actor owner, boolean vertical) {
        this.owner = owner;
        this.vertical = vertical;
    }

    @Override
    public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
        return this.handleBoundsContains(x, y);
    }

    @Override
    public void touchDragged(InputEvent event, float x, float y, int pointer) {
        super.touchDragged(event, x, y, pointer);
        if (this.contains(x, y)) {
            this.setCustomCursor();
        } else {
            this.clearCustomCursor();
        }
    }

    @Override
    public boolean mouseMoved(InputEvent event, float x, float y) {
        super.mouseMoved(event, x, y);
        if (this.handleBoundsContains(x, y)) {
            this.setCustomCursor();
        } else {
            this.clearCustomCursor();
        }
        return false;
    }

    @Override
    public void exit(InputEvent event, float x, float y, int pointer, Actor toActor) {
        super.exit(event, x, y, pointer, toActor);
        if (!(pointer != -1 || toActor != null && toActor.isDescendantOf(this.owner))) {
            this.clearCustomCursor();
        }
    }

    private void setCustomCursor() {
        Cursor.SystemCursor targetCursor = this.vertical ? Cursor.SystemCursor.VerticalResize : Cursor.SystemCursor.HorizontalResize;
        if (this.currentCursor != targetCursor) {
            Gdx.graphics.setSystemCursor(targetCursor);
            this.currentCursor = targetCursor;
        }
    }

    private void clearCustomCursor() {
        if (this.currentCursor != null) {
            CursorManager.restoreDefaultCursor();
            this.currentCursor = null;
        }
    }

    protected abstract boolean handleBoundsContains(float var1, float var2);

    protected abstract boolean contains(float var1, float var2);
}

