/*
 * Decompiled with CFR 0.152.
 */
package dev.lyze.flexbox;

import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.ui.WidgetGroup;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.scenes.scene2d.utils.Layout;
import com.badlogic.gdx.utils.Array;
import io.github.orioncraftmc.meditate.YogaConfig;
import io.github.orioncraftmc.meditate.YogaConfigFactory;
import io.github.orioncraftmc.meditate.YogaNode;
import io.github.orioncraftmc.meditate.YogaNodeFactory;
import io.github.orioncraftmc.meditate.YogaNodeWrapper;
import io.github.orioncraftmc.meditate.enums.YogaEdge;

public class FlexBox
extends WidgetGroup {
    private final YogaConfig config;
    private final YogaNode root;
    private final Array<YogaActor> nodes = new Array();
    private boolean prefSizeInvalid;
    private float prefWidth;
    private float prefHeight;
    private float lastPrefWidth;
    private float lastPrefHeight;

    public FlexBox() {
        this.config = YogaConfigFactory.create();
        this.root = YogaNodeFactory.create();
        this.setTransform(false);
        this.setTouchable(Touchable.childrenOnly);
    }

    public FlexBox(YogaConfig config) {
        this.config = config;
        this.root = YogaNodeFactory.create();
    }

    @Override
    public void layout() {
        Actor actor;
        super.layout();
        for (YogaActor yogaActor : this.nodes) {
            YogaNode yogaNode = yogaActor.node;
            actor = yogaActor.actor;
            if (!(actor instanceof Layout)) continue;
            Layout layout = (Layout)((Object)actor);
            if (!((YogaNodeWrapper)yogaNode).minWidthManuallySet) {
                yogaNode.setMinWidth(layout.getMinWidth() + yogaNode.getLayoutPadding(YogaEdge.LEFT) + yogaNode.getLayoutPadding(YogaEdge.RIGHT));
                ((YogaNodeWrapper)yogaNode).minWidthManuallySet = false;
            }
            if (((YogaNodeWrapper)yogaNode).minHeightManuallySet) continue;
            yogaNode.setMinHeight(layout.getMinHeight() + yogaNode.getLayoutPadding(YogaEdge.BOTTOM) + yogaNode.getLayoutPadding(YogaEdge.TOP));
            ((YogaNodeWrapper)yogaNode).minHeightManuallySet = false;
        }
        if (this.prefSizeInvalid) {
            this.calcPrefSize();
        }
        if (this.prefWidth != this.lastPrefWidth || this.prefHeight != this.lastPrefHeight) {
            this.lastPrefWidth = this.prefWidth;
            this.lastPrefHeight = this.prefHeight;
            this.invalidateHierarchy();
        }
        this.root.calculateLayout(this.getWidth(), this.getHeight());
        for (YogaActor yogaActor : this.nodes) {
            YogaNode node = yogaActor.getNode();
            actor = yogaActor.getActor();
            float x = node.getLayoutX();
            float y = node.getLayoutY();
            for (YogaNode parent = node.getOwner(); parent != null; parent = parent.getOwner()) {
                x += parent.getLayoutX();
                y += parent.getLayoutY();
            }
            actor.setBounds(x + node.getLayoutPadding(YogaEdge.LEFT), this.getHeight() - y - node.getLayoutHeight() + node.getLayoutPadding(YogaEdge.BOTTOM), node.getLayoutWidth() - node.getLayoutPadding(YogaEdge.LEFT) - node.getLayoutPadding(YogaEdge.RIGHT), node.getLayoutHeight() - node.getLayoutPadding(YogaEdge.BOTTOM) - node.getLayoutPadding(YogaEdge.TOP));
        }
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        this.validate();
        if (this.isTransform()) {
            this.applyTransform(batch, this.computeTransform());
            this.drawBackground(this.root, batch, 0.0f, 0.0f);
            this.drawChildren(batch, parentAlpha);
            this.resetTransform(batch);
        } else {
            this.drawBackground(this.root, batch, this.getX(), this.getY());
            super.draw(batch, parentAlpha);
        }
    }

    private void drawBackground(YogaNode node, Batch batch, float offsetX, float offsetY) {
        Drawable background = node.getBackground();
        if (background != null) {
            float x = node.getLayoutX();
            float y = node.getLayoutY();
            for (YogaNode parent = node.getOwner(); parent != null; parent = parent.getOwner()) {
                x += parent.getLayoutX();
                y += parent.getLayoutY();
            }
            background.draw(batch, x + offsetX, this.getHeight() - y - node.getLayoutHeight() + offsetY, node.getLayoutWidth(), node.getLayoutHeight());
        }
        for (int i = 0; i < node.getChildCount(); ++i) {
            YogaNode child = node.getChildAt(i);
            this.drawBackground(child, batch, offsetX, offsetY);
        }
    }

    public YogaNode add() {
        return this.addAt(null, this.root.getChildCount());
    }

    public YogaNode add(Actor actor) {
        return this.addAt(actor, this.root.getChildCount());
    }

    public YogaNode addAt(int i) {
        return this.addAsChild(this.root, null, i);
    }

    public YogaNode addAt(Actor actor, int i) {
        return this.addAsChild(this.root, actor, i);
    }

    public YogaNode addAsChild(YogaNode parent) {
        return this.addAsChild(parent, null, parent.getChildCount());
    }

    public YogaNode addAsChild(YogaNode parent, Actor actor) {
        return this.addAsChild(parent, actor, parent.getChildCount());
    }

    public YogaNode addAsChild(YogaNode parent, int i) {
        return this.addAsChild(parent, null, i);
    }

    public YogaNode addAsChild(YogaNode parent, Actor actor, int i) {
        YogaNode node = YogaNodeFactory.create(this.config);
        if (actor == null) {
            parent.addChildAt(node, i);
            return node;
        }
        if (actor instanceof Layout) {
            Layout layout = (Layout)((Object)actor);
            node.setMinWidth(layout.getMinWidth());
            node.setMinHeight(layout.getMinHeight());
            ((YogaNodeWrapper)node).minWidthManuallySet = false;
            ((YogaNodeWrapper)node).minHeightManuallySet = false;
        } else {
            node.setWidth(actor.getWidth());
            node.setHeight(actor.getHeight());
        }
        this.nodes.add(new YogaActor(node, actor));
        parent.addChildAt(node, i);
        this.addActor(actor);
        return node;
    }

    public void remove(YogaNode node) {
        YogaNode parent = node.getOwner();
        for (int i = parent.getChildCount() - 1; i >= 0; --i) {
            if (parent.getChildAt(i) != node) continue;
            parent.removeChildAt(i);
            for (YogaActor yogaActor : this.nodes) {
                if (yogaActor.getNode() != node) continue;
                this.nodes.removeValue(yogaActor, true);
                this.removeActor(yogaActor.getActor());
                return;
            }
        }
    }

    @Override
    public void clearChildren() {
        super.clearChildren();
        for (YogaActor node : this.nodes) {
            this.removeActor(node.getActor());
        }
        this.nodes.clear();
        while (this.root.getChildCount() > 0) {
            this.root.removeChildAt(0);
        }
    }

    public YogaNode getRoot() {
        return this.root;
    }

    @Override
    public void invalidate() {
        super.invalidate();
        this.prefSizeInvalid = true;
    }

    @Override
    public float getPrefWidth() {
        if (this.prefSizeInvalid) {
            this.calcPrefSize();
        }
        return this.prefWidth;
    }

    @Override
    public float getPrefHeight() {
        if (this.prefSizeInvalid) {
            this.calcPrefSize();
        }
        return this.prefHeight;
    }

    private void calcPrefSize() {
        this.prefSizeInvalid = false;
        this.root.calculateLayout(0.0f, this.getHeight());
        float maxWidth = 0.0f;
        for (YogaActor yogaActor : this.nodes) {
            YogaNode node = yogaActor.getNode();
            maxWidth = Math.max(maxWidth, node.getLayoutX() + node.getLayoutWidth());
        }
        this.prefWidth = maxWidth;
        this.root.calculateLayout(this.getWidth(), 0.0f);
        float maxHeight = 0.0f;
        for (YogaActor yogaActor : this.nodes) {
            YogaNode node = yogaActor.getNode();
            maxHeight = Math.max(maxHeight, node.getLayoutY() + node.getLayoutHeight());
        }
        this.prefHeight = maxHeight;
    }

    @Override
    @Deprecated
    public void addActor(Actor actor) {
        super.addActor(actor);
    }

    @Override
    @Deprecated
    public void addActorAt(int index, Actor actor) {
        super.addActorAt(index, actor);
    }

    @Override
    @Deprecated
    public void addActorBefore(Actor actorBefore, Actor actor) {
        super.addActorBefore(actorBefore, actor);
    }

    @Override
    @Deprecated
    public void addActorAfter(Actor actorAfter, Actor actor) {
        super.addActorAfter(actorAfter, actor);
    }

    @Override
    @Deprecated
    public boolean removeActor(Actor actor) {
        return super.removeActor(actor);
    }

    @Override
    @Deprecated
    public boolean removeActor(Actor actor, boolean unfocus) {
        return super.removeActor(actor, unfocus);
    }

    @Override
    @Deprecated
    public Actor removeActorAt(int index, boolean unfocus) {
        return super.removeActorAt(index, unfocus);
    }

    private static class YogaActor {
        private final YogaNode node;
        private final Actor actor;

        public YogaActor(YogaNode node, Actor actor) {
            this.node = node;
            this.actor = actor;
        }

        public YogaNode getNode() {
            return this.node;
        }

        public Actor getActor() {
            return this.actor;
        }
    }
}

