/*
 * Decompiled with CFR 0.152.
 */
package group24.escaperoom;

import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import java.util.HashMap;
import java.util.Optional;
import java.util.logging.Logger;

public class AssetManager
extends com.badlogic.gdx.assets.AssetManager {
    Logger log = Logger.getLogger(AssetManager.class.getName());
    Optional<TextureAtlas> userAtlas = Optional.empty();
    TextureAtlas defaultAtlas;
    HashMap<String, TextureAtlas.AtlasRegion> loadedTextures = new HashMap();
    private static AssetManager mgr;

    public static AssetManager instance() {
        if (mgr == null) {
            mgr = new AssetManager();
        }
        return mgr;
    }

    private AssetManager() {
        this.load("texture_atlas/textureAtlas.atlas", TextureAtlas.class);
        this.finishLoadingAsset("texture_atlas/textureAtlas.atlas");
        this.defaultAtlas = (TextureAtlas)this.get("texture_atlas/textureAtlas.atlas");
    }

    public void registerUserAtlas(TextureAtlas atlas) {
        this.userAtlas.ifPresent(ua -> this.loadedTextures.clear());
        this.userAtlas = Optional.of(atlas);
    }

    public void clearUserTextures() {
        this.userAtlas.ifPresent(a -> a.dispose());
        this.userAtlas = Optional.empty();
    }

    public void invalidateTextureCache() {
        this.loadedTextures.clear();
    }

    public TextureAtlas.AtlasRegion getRegion(String identifier) {
        TextureAtlas.AtlasRegion cached = this.loadedTextures.get(identifier);
        if (cached != null) {
            return cached;
        }
        TextureAtlas.AtlasRegion region = this.userAtlas.map(a -> a.findRegion(identifier)).orElse(null);
        if (region != null) {
            this.loadedTextures.put(identifier, region);
            return region;
        }
        region = this.defaultAtlas.findRegion(identifier);
        if (region != null) {
            this.loadedTextures.put(identifier, region);
            return region;
        }
        this.log.warning("Requested texture that does not exist! Requested: " + identifier);
        return this.defaultAtlas.findRegion("placeholder");
    }

    public Texture loadTextureBlocking(String path) {
        try {
            AssetManager.instance().load(path, Texture.class);
            AssetManager.instance().finishLoadingAsset(path);
            return AssetManager.instance().get(path, Texture.class);
        }
        catch (Exception gdxre) {
            System.err.println("failed to load title img");
            return null;
        }
    }
}

