/*
 * Decompiled with CFR 0.152.
 */
package group24.escaperoom;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Screen;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.glutils.FrameBuffer;
import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.utils.ScreenUtils;
import group24.escaperoom.EscapeRoomGame;
import group24.escaperoom.screens.AbstractScreen;
import group24.escaperoom.screens.BackManager;
import group24.escaperoom.screens.GameScreen;
import group24.escaperoom.screens.LevelEditorScreen;

public class ScreenManager {
    private static ScreenManager instance = new ScreenManager();
    private ScreenType type;
    private EscapeRoomGame game;

    public static ScreenManager instance() {
        return instance;
    }

    public void initialize(EscapeRoomGame game) {
        this.game = game;
    }

    public ScreenType getCurrentScreenType() {
        return this.type;
    }

    public AbstractScreen getCurrent() {
        return (AbstractScreen)AbstractScreen.class.cast(this.game.getScreen());
    }

    public void showScreen(AbstractScreen nextScreen, boolean dispose) {
        float delta;
        this.type = nextScreen instanceof GameScreen ? ScreenType.Game : (nextScreen instanceof LevelEditorScreen ? ScreenType.Editor : ScreenType.Menu);
        Screen screen = this.game.getScreen();
        BackManager.setOwner(null);
        if (screen == null) {
            this.game.setScreen(nextScreen);
            return;
        }
        FrameBuffer currentFB = new FrameBuffer(Pixmap.Format.RGBA8888, Gdx.graphics.getWidth(), Gdx.graphics.getHeight(), false);
        FrameBuffer nextFB = new FrameBuffer(Pixmap.Format.RGBA8888, Gdx.graphics.getWidth(), Gdx.graphics.getHeight(), false);
        float transitionDuration = 0.1f;
        SpriteBatch batch = new SpriteBatch();
        for (float time = 0.0f; time < transitionDuration; time += delta) {
            ScreenUtils.clear(0.0f, 0.0f, 0.0f, 1.0f);
            delta = Gdx.graphics.getDeltaTime();
            currentFB.begin();
            screen.render(delta);
            currentFB.end();
            nextFB.begin();
            nextScreen.render(delta);
            nextFB.end();
            Texture currentTexture = (Texture)currentFB.getColorBufferTexture();
            Texture nextTexture = (Texture)nextFB.getColorBufferTexture();
            float alpha = Interpolation.fade.apply(time / transitionDuration);
            batch.begin();
            batch.setColor(1.0f, 1.0f, 1.0f, alpha);
            batch.draw(currentTexture, 0.0f, 0.0f, 0.0f, 0.0f, currentTexture.getWidth(), currentTexture.getHeight(), 1.0f, 1.0f, 0.0f, 0, 0, currentTexture.getWidth(), currentTexture.getHeight(), false, true);
            batch.setColor(1.0f, 1.0f, 1.0f, 1.0f - alpha);
            batch.draw(nextTexture, 0.0f, 0.0f, 0.0f, 0.0f, nextFB.getWidth(), nextFB.getHeight(), 1.0f, 1.0f, 0.0f, 0, 0, nextTexture.getWidth(), nextFB.getHeight(), false, true);
            batch.end();
        }
        if (dispose) {
            screen.dispose();
        }
        BackManager.setOwner(nextScreen);
        this.game.setScreen(nextScreen);
    }

    public void showScreen(AbstractScreen nextScreen) {
        this.showScreen(nextScreen, true);
    }

    public static enum ScreenType {
        Game,
        Editor,
        Menu;

    }
}

