/*
 * Decompiled with CFR 0.152.
 */
package group24.escaperoom.control;

import com.badlogic.gdx.utils.Array;
import group24.escaperoom.control.Input;
import group24.escaperoom.control.InputModifier;
import group24.escaperoom.control.InputOverride;
import group24.escaperoom.control.Keyboard;
import group24.escaperoom.control.MapGroup;
import group24.escaperoom.control.bindings.InputBinding;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Set;
import java.util.Stack;
import java.util.TreeMap;

public class ControlsManager {
    private static InputGroupMap permMappings = new InputGroupMap();
    private static InputGroupMap activeMappings = new InputGroupMap();
    private static BoundInputs register = new BoundInputs();
    private static BoundInputs pregister = new BoundInputs();
    private static Stack<InputOverride> overrides = new Stack();
    private static Array<InputPair> processedInputs = new Array();
    private static boolean keyboardEnabled = true;

    public static void setKeyboardEnabled(boolean keyboardEnabled) {
        ControlsManager.keyboardEnabled = keyboardEnabled;
    }

    private static void registerNewMapping(InputGroupMap map, Input input) {
        if (map.get((Object)input.getGroup()) == null) {
            map.put(input.getGroup(), new Array());
        }
        ((Array)map.get((Object)input.getGroup())).add(input);
    }

    private static void registerPermanentMapping(Input input) {
        ControlsManager.registerNewMapping(permMappings, input);
    }

    private static void registerMapping(Input input) {
        ControlsManager.registerNewMapping(activeMappings, input);
    }

    public static void registerPermanentInput(Input input, InputType type, InputAction action) {
        ControlsManager.registerPermanentMapping(input);
        for (InputBinding bind : input.getBinds()) {
            ControlsManager.registerNewInput(new BoundInput(input, bind), type, action, pregister);
        }
    }

    public static void registerInput(Input input, InputType type, InputAction action) {
        ControlsManager.registerMapping(input);
        for (InputBinding bind : input.getBinds()) {
            ControlsManager.registerNewInput(new BoundInput(input, bind), type, action, register);
        }
    }

    public static void clearRegisteredInputs() {
        register.clear();
        activeMappings.clear();
        overrides.clear();
    }

    public static void pushOverride(InputOverride override) {
        overrides.push(override);
    }

    public static void popOverride(InputOverride override) {
        if (overrides.isEmpty()) {
            return;
        }
        if (overrides.peek() == override) {
            overrides.pop();
        }
    }

    private static void registerNewInput(BoundInput key, InputType type, InputAction action, BoundInputs store) {
        if (store.containsKey(key)) {
            ((Array)((HashMap)store.get(key)).get((Object)type)).add(action);
        } else {
            HashMap typeMap = new HashMap();
            for (InputType t : InputType.values()) {
                typeMap.put(t, new Array());
            }
            ((Array)typeMap.get((Object)type)).add(action);
            store.put(key, typeMap);
        }
    }

    public static void processInputs() {
        processedInputs.clear();
        pregister.forEach((input, actions) -> ControlsManager.handleInput(input, actions));
        register.forEach((input, actions) -> {
            if (!keyboardEnabled && input.binding.getPair().method == InputMethod.KEYBOARD) {
                return;
            }
            if (ControlsManager.processOverride(input)) {
                return;
            }
            ControlsManager.handleInput(input, actions);
        });
    }

    private static boolean processOverride(BoundInput bindingKey) {
        if (overrides.isEmpty()) {
            return false;
        }
        if (processedInputs.contains(bindingKey.binding.getPair(), false)) {
            return true;
        }
        if (!overrides.peek().getOverriddenInputs().contains((Object)bindingKey.input)) {
            return false;
        }
        InputPair pair = null;
        pair = Keyboard.isHeld(bindingKey.binding);
        if (pair != null && overrides.peek().handleInput(bindingKey.input, InputType.HELD)) {
            processedInputs.add(pair);
            return true;
        }
        pair = Keyboard.isPressed(bindingKey.binding);
        if (pair != null && overrides.peek().handleInput(bindingKey.input, InputType.PRESSED)) {
            processedInputs.add(pair);
            return true;
        }
        return false;
    }

    private static void handleInput(BoundInput bindingKey, HashMap<InputType, Array<InputAction>> actions) {
        InputBinding input = bindingKey.binding;
        if (processedInputs.contains(input.getPair(), false)) {
            return;
        }
        actions.forEach((type, actionList) -> {
            InputPair pair = null;
            switch (type) {
                case HELD: {
                    pair = Keyboard.isHeld(input);
                    break;
                }
                case PRESSED: {
                    pair = Keyboard.isPressed(input);
                }
            }
            if (pair != null) {
                actionList.forEach(InputAction::perform);
                processedInputs.add(pair);
            }
        });
    }

    public static InputGroupMap registedMappings() {
        InputGroupMap ret = new InputGroupMap();
        ret.putAll(permMappings);
        ret.putAll(activeMappings);
        return ret;
    }

    public static Input matchesInput(int code, InputMethod method, InputModifier ... modifiers) {
        Set<InputModifier> givenMods = Set.of(modifiers);
        for (Input i : Input.values()) {
            for (InputBinding bind : i.getBinds()) {
                Set<InputModifier> expctMods;
                InputPair pair = bind.getPair();
                if (pair.key != code || pair.method != method || !givenMods.equals(expctMods = Set.of(bind.getModifiers()))) continue;
                return i;
            }
        }
        return null;
    }

    public static final class InputGroupMap
    extends HashMap<MapGroup, Array<Input>> {
    }

    private static class BoundInput {
        Input input;
        InputBinding binding;

        BoundInput(Input input, InputBinding binding) {
            this.input = input;
            this.binding = binding;
        }
    }

    public static final class BoundInputs
    extends TreeMap<BoundInput, HashMap<InputType, Array<InputAction>>> {
        BoundInputs() {
            super(new BoundInputComparator());
        }
    }

    public static enum InputType {
        HELD,
        PRESSED;

    }

    public static interface InputAction {
        public void perform();
    }

    public static class InputPair {
        final int key;
        final InputMethod method;

        public InputPair(int key, InputMethod method) {
            this.key = key;
            this.method = method;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof InputPair)) {
                return false;
            }
            InputPair other = (InputPair)obj;
            return this.key == other.key && this.method.equals((Object)other.method);
        }
    }

    public static enum InputMethod {
        KEYBOARD,
        MOUSE;

    }

    private static class BoundInputComparator
    implements Comparator<BoundInput> {
        private BoundInputComparator() {
        }

        @Override
        public int compare(BoundInput left, BoundInput right) {
            InputPair l = left.binding.getPair();
            InputPair r = right.binding.getPair();
            if (l.key != r.key) {
                return r.key - l.key;
            }
            InputModifier[] rmods = right.binding.getModifiers();
            InputModifier[] lmods = left.binding.getModifiers();
            if (rmods.length != 0 && rmods.length == lmods.length) {
                for (int mi = 0; mi < rmods.length && mi < lmods.length; ++mi) {
                    if (rmods[mi] == lmods[mi]) continue;
                    return rmods[mi].ordinal() - lmods[mi].ordinal();
                }
                return 0;
            }
            return rmods.length - lmods.length;
        }
    }
}

