/*
 * Decompiled with CFR 0.152.
 */
package group24.escaperoom.control;

import group24.escaperoom.control.ControlsManager;
import group24.escaperoom.control.InputModifier;
import group24.escaperoom.control.MapGroup;
import group24.escaperoom.control.bindings.InputBinding;
import group24.escaperoom.control.bindings.KeyBinding;
import group24.escaperoom.control.bindings.MouseBinding;
import java.util.ArrayList;

public enum Input {
    MOVE_UP(MapGroup.GENERAL, "Move Up", new KeyBinding(51), new KeyBinding(19)),
    MOVE_LEFT(MapGroup.GENERAL, "Move Left", new KeyBinding(29), new KeyBinding(21)),
    MOVE_DOWN(MapGroup.GENERAL, "Move Down", new KeyBinding(47), new KeyBinding(20)),
    MOVE_RIGHT(MapGroup.GENERAL, "Move Right", new KeyBinding(32), new KeyBinding(22)),
    BACK(MapGroup.GENERAL, "Back", new KeyBinding(111)),
    ZOOM_IN(MapGroup.GENERAL, "Zoom In", new KeyBinding(70, InputModifier.SHIFT), new KeyBinding(70)),
    ZOOM_OUT(MapGroup.GENERAL, "Zoom Out", new KeyBinding(69)),
    COPY(MapGroup.EDITOR, "Copy", new KeyBinding(31, InputModifier.CONTROL)),
    PASTE(MapGroup.EDITOR, "Paste", new KeyBinding(50, InputModifier.CONTROL)),
    UNDO(MapGroup.EDITOR, "Undo", new KeyBinding(54, InputModifier.CONTROL)),
    REDO(MapGroup.EDITOR, "Redo", new KeyBinding(46, InputModifier.CONTROL)),
    ROTCW(MapGroup.EDITOR, "Rotate Item (Hovered)", new KeyBinding(46)),
    ROTCCW(MapGroup.EDITOR, "Rotate Item (Hovered)", new KeyBinding(46, InputModifier.SHIFT)),
    MIRROR_H(MapGroup.EDITOR, "Mirror Item Horizontally (Hovered)", new KeyBinding(36, InputModifier.SHIFT)),
    MIRROR_V(MapGroup.EDITOR, "Mirror Item Vertically (Hovered)", new KeyBinding(50, InputModifier.SHIFT)),
    KEYBIND_HELP(MapGroup.EDITOR, "Key Bind Menu", new KeyBinding(36)),
    DELETE_SELECTION(MapGroup.EDITOR, "Delete Active Selection", new KeyBinding(67), new KeyBinding(112)),
    TOOL_ROT(MapGroup.EDITOR, "Rotation Tool", new KeyBinding(46, InputModifier.CONTROL, InputModifier.SHIFT)),
    TOOL_PAN(MapGroup.EDITOR, "Pan Tool", new KeyBinding(62)),
    TOOL_MOV(MapGroup.EDITOR, "Move Tool", new KeyBinding(50)),
    TOOL_PPT(MapGroup.EDITOR, "Property Tool", new KeyBinding(44)),
    TOOL_FILL(MapGroup.EDITOR, "Fill Tool", new KeyBinding(35)),
    TOOL_SEL(MapGroup.EDITOR, "Select Tool", new KeyBinding(41)),
    TOOL_EYEDROP(MapGroup.EDITOR, "Eye Drop Tool", new KeyBinding(37)),
    TOOL_DEL(MapGroup.EDITOR, "Delete Tool", new KeyBinding(33)),
    SELECT(MapGroup.EDITOR, "Select Item/Pan Camera", new MouseBinding(0)),
    SELECT_MULTI(MapGroup.EDITOR, "Add to Selection", new MouseBinding(0, InputModifier.SHIFT)),
    CONTEXT(MapGroup.EDITOR, "Open Context Menu", new MouseBinding(1)),
    INTERACT(MapGroup.GAME, "Interact", new KeyBinding(34)),
    CHANGE_INTERACT_FOCUS(MapGroup.GAME, "Cycle Interact Focus", new KeyBinding(45)),
    INVENTORY(MapGroup.GAME, "Open Inventory", new KeyBinding(37)),
    PRINT_INVENTORY(MapGroup.DEBUG, "Print Inventory", new KeyBinding(39));

    private InputBinding[] binds;
    private ArrayList<ControlsManager.InputPair> pairs;
    private String description;
    private MapGroup group;

    private Input(MapGroup grp, String desc, InputBinding ... keys) {
        this.binds = keys;
        this.description = desc;
        this.group = grp;
        this.pairs = new ArrayList(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            this.pairs.add(this.binds[i].getPair());
        }
    }

    public InputBinding[] getBinds() {
        return this.binds;
    }

    public ArrayList<ControlsManager.InputPair> getInputs() {
        return this.pairs;
    }

    public MapGroup getGroup() {
        return this.group;
    }

    public MappingDescription description() {
        String[] bindingStrs = new String[this.binds.length];
        for (int i = 0; i < this.binds.length; ++i) {
            bindingStrs[i] = this.binds[i].toString();
        }
        return new MappingDescription(this.description, bindingStrs);
    }

    public static final class MappingDescription {
        public final String desc;
        public final String[] bindings;

        public MappingDescription(String description, String ... bindStrings) {
            this.desc = description;
            this.bindings = bindStrings;
        }
    }
}

