/*
 * Decompiled with CFR 0.152.
 */
package group24.escaperoom.control.bindings;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Input;
import group24.escaperoom.control.ControlsManager;
import group24.escaperoom.control.InputModifier;
import group24.escaperoom.control.bindings.InputBinding;

public class KeyBinding
extends InputBinding {
    public KeyBinding(int bind) {
        this(bind, new InputModifier[0]);
    }

    public KeyBinding(int bind, InputModifier ... modifiers) {
        this.key = bind;
        this.modifiers = modifiers;
        this.method = ControlsManager.InputMethod.KEYBOARD;
    }

    @Override
    public boolean wasPressed() {
        if (!Gdx.input.isKeyJustPressed(this.key)) {
            return false;
        }
        for (InputModifier modifier : this.modifiers) {
            if (modifier.isDown()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isDown() {
        if (!Gdx.input.isKeyPressed(this.key)) {
            return false;
        }
        for (InputModifier modifier : this.modifiers) {
            if (modifier.isDown()) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return this.modifierString() + Input.Keys.toString(this.key);
    }
}

