/*
 * Decompiled with CFR 0.152.
 */
package group24.escaperoom.control.bindings;

import com.badlogic.gdx.Gdx;
import group24.escaperoom.control.ControlsManager;
import group24.escaperoom.control.InputModifier;
import group24.escaperoom.control.bindings.InputBinding;

public class MouseBinding
extends InputBinding {
    public MouseBinding(int bind) {
        this(bind, new InputModifier[0]);
    }

    public MouseBinding(int bind, InputModifier ... modifiers) {
        this.key = bind;
        this.modifiers = modifiers;
        this.method = ControlsManager.InputMethod.MOUSE;
    }

    @Override
    public boolean wasPressed() {
        if (!Gdx.input.isButtonJustPressed(this.key)) {
            return false;
        }
        for (InputModifier modifier : this.modifiers) {
            if (modifier.isDown()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isDown() {
        if (!Gdx.input.isButtonPressed(this.key)) {
            return false;
        }
        for (InputModifier modifier : this.modifiers) {
            if (modifier.isDown()) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        String inputString = "";
        switch (this.key) {
            case 1: {
                inputString = "RightClick";
                break;
            }
            case 0: {
                inputString = "LeftClick";
                break;
            }
            case 2: {
                inputString = "MiddleMouse";
            }
        }
        return this.modifierString() + inputString;
    }
}

