/*
 * Decompiled with CFR 0.152.
 */
package group24.escaperoom.data;

import group24.escaperoom.data.EditorEvent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class EditorEventBus {
    private static final HashMap<EditorEventListener, EditorEventFilter> listeners = new HashMap();
    private static final HashSet<EditorEventListener> toRemove = new HashSet();

    public void addListener(EditorEventListener listener) {
        listeners.put(listener, null);
    }

    public void addListener(EditorEventListener listener, EditorEventFilter filter) {
        listeners.put(listener, filter);
    }

    public void removeListener(EditorEventListener listener) {
        toRemove.add(listener);
    }

    public static void post(EditorEvent event) {
        toRemove.forEach(l -> listeners.remove(l));
        for (Map.Entry<EditorEventListener, EditorEventFilter> pair : listeners.entrySet()) {
            EditorEventListener listener = pair.getKey();
            EditorEventFilter filter = pair.getValue();
            if (filter != null && !filter.applies(event)) continue;
            listener.handle(event);
        }
    }

    @FunctionalInterface
    public static interface EditorEventListener {
        public void handle(EditorEvent var1);
    }

    @FunctionalInterface
    public static interface EditorEventFilter {
        public boolean applies(EditorEvent var1);
    }
}

