/*
 * Decompiled with CFR 0.152.
 */
package group24.escaperoom.data;

import com.badlogic.gdx.utils.Null;
import group24.escaperoom.data.GameContext;
import group24.escaperoom.entities.Item;

public class GameEvent {
    public final GameContext ctx;
    public final EventType type;
    @Null
    public final Item source;
    @Null
    public final Item target;
    @Null
    public final String message;

    public String toString() {
        if (this.message != null) {
            return this.message;
        }
        switch (this.type) {
            case ItemObtained: {
                return "Added " + this.source.getItemName() + " to inventory";
            }
        }
        return "";
    }

    private GameEvent(EventType type, GameContext ctx, @Null Item source, @Null Item target, @Null String message) {
        this.type = type;
        this.ctx = ctx;
        this.source = source;
        this.target = target;
        this.message = message;
    }

    public static enum EventType {
        ItemObtained,
        ItemStateChange;

    }

    public static class Builder {
        GameContext ctx;
        EventType type;
        @Null
        Item source;
        @Null
        Item target;
        String message = "";

        public Builder(EventType eventType, GameContext context) {
            this.type = eventType;
            this.ctx = context;
        }

        public Builder target(Item targetItem) {
            this.target = targetItem;
            return this;
        }

        public Builder message(String eventMessage) {
            this.message = eventMessage;
            return this;
        }

        public Builder source(Item sourceItem) {
            this.source = sourceItem;
            return this;
        }

        public GameEvent build() {
            return new GameEvent(this.type, this.ctx, this.source, this.target, this.message);
        }
    }
}

