/*
 * Decompiled with CFR 0.152.
 */
package group24.escaperoom.data;

import group24.escaperoom.data.GameEvent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class GameEventBus {
    private static final GameEventBus inst = new GameEventBus();
    private final HashMap<GameEventListener, GameEventFilter> listeners = new HashMap();
    private final HashSet<GameEventListener> toRemove = new HashSet();

    public static GameEventBus get() {
        return inst;
    }

    public void addListener(GameEventListener listener) {
        this.listeners.put(listener, null);
    }

    public void addListener(GameEventListener listener, GameEventFilter filter) {
        this.listeners.put(listener, filter);
    }

    public void removeListener(GameEventListener listener) {
        this.toRemove.add(listener);
    }

    public void post(GameEvent event) {
        this.toRemove.forEach(l -> this.listeners.remove(l));
        for (Map.Entry<GameEventListener, GameEventFilter> pair : this.listeners.entrySet()) {
            GameEventListener listener = pair.getKey();
            GameEventFilter filter = pair.getValue();
            if (filter != null && !filter.applies(event)) continue;
            listener.handle(event);
        }
    }

    @FunctionalInterface
    public static interface GameEventListener {
        public void handle(GameEvent var1);
    }

    @FunctionalInterface
    public static interface GameEventFilter {
        public boolean applies(GameEvent var1);
    }
}

