/*
 * Decompiled with CFR 0.152.
 */
package group24.escaperoom.data;

import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.JsonValue;
import group24.escaperoom.data.Drawable;
import group24.escaperoom.entities.Item;
import group24.escaperoom.utils.Types;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Optional;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class Grid
implements Json.Serializable {
    private static Logger log = Logger.getLogger(Grid.class.getName());
    public HashMap<Integer, Item> items = new HashMap();
    public HashMap<Integer, Item> placedItems = new HashMap();
    public static HashSet<Function<Grid, Void>> onMapCompletion = new HashSet();
    Tile[][] inner;
    int width;
    int height;
    static Grid instance;

    public TreeSet<Drawable> getDrawables() {
        return this.placedItems.values().stream().map(i -> i).collect(Collectors.toCollection(() -> new TreeSet<Drawable>(new DrawableComparator())));
    }

    public static Grid current() {
        return instance;
    }

    public Optional<Item> getItemByID(int id) {
        Item i = this.items.get(id);
        return i == null ? Optional.empty() : Optional.of(i);
    }

    public Grid() {
        instance = this;
    }

    public Grid(int w, int h) {
        this.width = w;
        this.height = h;
        this.inner = this.newEmptyInner(this.width, this.height);
        instance = this;
    }

    private Tile[][] newEmptyInner(int width, int height) {
        Tile[][] grid = new Tile[height][width];
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                grid[y][x] = new Tile(x, y);
            }
        }
        return grid;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public boolean containsItemWhere(Predicate<Item> predicate) {
        return this.findItemWhere(predicate).isPresent();
    }

    public Types.Size getSize() {
        return new Types.Size(this.width, this.height);
    }

    public Optional<Item> findItemWhere(Predicate<Item> predicate) {
        for (int y = this.height - 1; y >= 0; --y) {
            for (int x = 0; x < this.width; ++x) {
                Tile t = this.inner[y][x];
                for (int i = 0; i < t.stacksize; ++i) {
                    if (!predicate.test(t.items[i])) continue;
                    return Optional.of(t.items[i]);
                }
            }
        }
        return Optional.empty();
    }

    public Optional<Tile> getAt(int x, int y) {
        if (x < 0 || x >= this.width || y < 0 || y >= this.height) {
            return Optional.empty();
        }
        return Optional.of(this.inner[y][x]);
    }

    public void printGrid() {
        for (int y = this.height - 1; y >= 0; --y) {
            System.out.printf("%2d", y);
            for (int x = 0; x < this.width; ++x) {
                Tile t = this.inner[y][x];
                if (t.getX() != x || t.getY() != y) {
                    throw new IllegalStateException("tile is not in correct position");
                }
                System.out.print(this.inner[y][x].toString());
            }
            System.out.println();
        }
        System.out.printf(" ", new Object[0]);
        for (int x = 0; x < this.width; ++x) {
            System.out.printf("%10d", x);
        }
        System.out.println();
    }

    public boolean placeItem(Item item) {
        if (this.placedItems.containsKey(item.getID())) {
            return false;
        }
        this.placedItems.put(item.getID(), item);
        if (!this.items.containsKey(item.getID())) {
            this.items.put(item.getID(), item);
        }
        int bX = item.getX();
        int bY = item.getY();
        for (int y = 0; y < item.getHeight(); ++y) {
            for (int x = 0; x < item.getWidth(); ++x) {
                this.inner[bY + y][bX + x].addItem(item);
            }
        }
        return true;
    }

    public int getTileDepthOf(Item item) {
        int x = item.getX();
        int y = item.getY();
        if (x < 0 || x >= this.width || y < 0 || y >= this.height) {
            return -1;
        }
        Tile t = this.inner[y][x];
        Item[] items = t.getContainedItems();
        for (int i = 0; i < items.length; ++i) {
            if (items[i] == null) {
                return -1;
            }
            if (items[i].getID() != item.getID()) continue;
            return items.length - i - 1;
        }
        return -1;
    }

    public void removeItem(Item item) {
        this.placedItems.remove(item.getID());
        if (!item.isContained()) {
            this.items.remove(item.getID());
        }
        int bX = item.getX();
        int bY = item.getY();
        for (int y = 0; y < item.getHeight(); ++y) {
            for (int x = 0; x < item.getWidth(); ++x) {
                this.inner[bY + y][bX + x].remove(item);
            }
        }
    }

    @Override
    public void write(Json json) {
        json.writeValue("width", this.width);
        json.writeValue("height", this.height);
        json.writeArrayStart("items");
        this.items.forEach((id, i) -> {
            json.writeObjectStart();
            json.writeValue("id", id);
            i.write(json);
            json.writeObjectEnd();
        });
        json.writeArrayEnd();
        json.writeArrayStart("tiles");
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                this.inner[y][x].write(json);
            }
        }
        json.writeArrayEnd();
    }

    @Override
    public void read(Json json, JsonValue jsonData) {
        instance = this;
        this.width = jsonData.getInt("width");
        this.height = jsonData.getInt("height");
        JsonValue itemJson = jsonData.get("items");
        itemJson.forEach(itemData -> {
            Item i = new Item();
            i.read(json, (JsonValue)itemData);
            this.items.put(itemData.getInt("id"), i);
        });
        this.inner = this.newEmptyInner(this.width, this.height);
        JsonValue tiles = jsonData.get("tiles");
        tiles.forEach(tileData -> {
            Tile tile = new Tile();
            tile.read(json, (JsonValue)tileData);
            this.inner[tile.y][tile.x] = tile;
        });
        onMapCompletion.forEach(f -> f.apply(this));
        onMapCompletion.clear();
    }

    public class Tile
    implements Json.Serializable {
        boolean occupied = false;
        public int stacksize = 0;
        private static final int MAX_STACK = 5;
        int x;
        int y;
        Item[] items = new Item[5];

        public boolean canAdd(Item item) {
            return !this.occupied;
        }

        public String toString() {
            String ret = "[";
            for (int i = 0; i < 5; ++i) {
                ret = ret + (this.stacksize > i ? Integer.valueOf(this.items[i].getID()) : "__");
            }
            return ret + "]";
        }

        public Item[] getContainedItems() {
            Item[] contained = new Item[this.stacksize];
            for (int i = 0; i < this.stacksize; ++i) {
                contained[i] = this.items[i];
            }
            return contained;
        }

        public boolean contains(Item item) {
            for (int i = 0; i < this.stacksize; ++i) {
                if (this.items[i].getID() != item.getID()) continue;
                return true;
            }
            return false;
        }

        private void remove(Item item) {
            for (int i = 0; i < this.stacksize; ++i) {
                if (this.items[i].getID() != item.getID()) continue;
                --this.stacksize;
                this.occupied = false;
                for (int j = i; j < 4; ++j) {
                    this.items[j] = this.items[j + 1];
                }
                this.items[4] = null;
                return;
            }
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public Tile addItem(Item item) {
            if (this.contains(item)) {
                log.severe("Trying to add item to tile which already contains item?");
                return this;
            }
            if (this.occupied || this.stacksize >= 5) {
                throw new IllegalStateException("Invalid state in Tile::setObject -> stack is " + this.stacksize + " occupied is " + this.occupied);
            }
            this.items[this.stacksize] = item;
            ++this.stacksize;
            this.occupied = this.stacksize == 5;
            return this;
        }

        public Tile(int x, int y) {
            this.x = x;
            this.y = y;
        }

        public Tile() {
        }

        @Override
        public void write(Json json) {
            Item[] items = this.getContainedItems();
            if (items.length < 1) {
                return;
            }
            json.writeObjectStart();
            json.writeValue("x", this.x);
            json.writeValue("y", this.y);
            json.writeValue("stacksize", this.stacksize);
            json.writeValue("occupied", this.occupied);
            json.writeArrayStart("items");
            for (int i = 0; i < items.length; ++i) {
                json.writeObjectStart();
                json.writeValue("index", i);
                json.writeValue("id", items[i].getID());
                json.writeObjectEnd();
            }
            json.writeArrayEnd();
            json.writeObjectEnd();
        }

        @Override
        public void read(Json json, JsonValue jsonData) {
            this.x = jsonData.getInt("x");
            this.y = jsonData.getInt("y");
            this.stacksize = jsonData.getInt("stacksize");
            this.occupied = jsonData.getBoolean("occupied");
            jsonData.get("items").forEach(itemInfo -> {
                int id = itemInfo.getInt("id");
                Optional<Item> oItem = Grid.this.getItemByID(id);
                if (oItem.isEmpty()) {
                    log.severe("Item ID: " + id + " could not be found in the item map");
                }
                Grid.this.placedItems.put(id, oItem.get());
                this.items[itemInfo.getInt((String)"index")] = oItem.get();
            });
        }
    }

    public static class DrawableComparator
    implements Comparator<Drawable> {
        @Override
        public int compare(Drawable i1, Drawable i2) {
            int stackLevel2;
            int renderPriority2;
            int renderPriority1 = i1.renderPriority();
            if (renderPriority1 != (renderPriority2 = i2.renderPriority())) {
                return Integer.compare(renderPriority1, renderPriority2);
            }
            float y1 = i1.position().y;
            float y2 = i2.position().y;
            if (y1 != y2) {
                return Float.compare(y2, y1);
            }
            int stackLevel1 = i1.getTileDepth();
            if (stackLevel1 != (stackLevel2 = i2.getTileDepth())) {
                return Integer.compare(stackLevel2, stackLevel1);
            }
            return Integer.compare(i1.hashCode(), i2.hashCode());
        }
    }
}

