/*
 * Decompiled with CFR 0.152.
 */
package group24.escaperoom.data;

import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.JsonWriter;
import group24.escaperoom.data.MapMetadata;
import group24.escaperoom.entities.Item;
import group24.escaperoom.utils.FileUtils;
import java.io.File;
import java.io.FileOutputStream;

public class ItemSaver {
    public static boolean saveCustomItem(Item item, MapMetadata metadata) {
        File mapDir = new File(FileUtils.getAppDataDir());
        if (!FileUtils.tryCreateFolder(mapDir)) {
            return false;
        }
        File dir = new File(metadata.locations.mapBasePath);
        if (!FileUtils.tryCreateFolder(dir)) {
            return false;
        }
        dir = new File(metadata.locations.mapContentPath);
        if (!FileUtils.tryCreateFolder(dir)) {
            return false;
        }
        dir = new File(metadata.locations.mapContentPath + "/objects");
        if (!FileUtils.tryCreateFolder(dir)) {
            return false;
        }
        dir = new File(metadata.locations.mapContentPath + "/objects/" + item.getType().category);
        if (!FileUtils.tryCreateFolder(dir)) {
            return false;
        }
        String fileName = Integer.toString(item.getType().name.hashCode()) + ".json";
        File itemFile = new File(dir, fileName);
        try {
            FileOutputStream fout = new FileOutputStream(itemFile);
            Json j = new Json();
            j.setOutputType(JsonWriter.OutputType.json);
            fout.write(j.prettyPrint(item.getType()).getBytes());
            fout.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }
}

