/*
 * Decompiled with CFR 0.152.
 */
package group24.escaperoom.data;

import group24.escaperoom.data.MapMetadata;
import group24.escaperoom.data.Networking;
import group24.escaperoom.data.User;
import group24.escaperoom.utils.FileUtils;
import java.io.File;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

public class MapDownloader {
    public static Optional<DownloadOutput> prepareDownloadPath(MapMetadata metadata) {
        if (!User.isLoggedIn()) {
            return Optional.of(new DownloadOutput("You must be logged in to download a map"));
        }
        if (metadata.mapID.isEmpty()) {
            return Optional.of(new DownloadOutput("Map is missing a map ID!"));
        }
        File downloadsDir = new File(FileUtils.getAppDataDir() + "maps/downloaded/");
        if (!downloadsDir.exists() && !downloadsDir.mkdirs()) {
            return Optional.of(new DownloadOutput("Unable to create downloads directory"));
        }
        File mapDir = new File(metadata.locations.mapBasePath);
        if (mapDir.exists()) {
            return Optional.of(new DownloadOutput("Map already downloaded"));
        }
        if (!mapDir.mkdirs()) {
            return Optional.of(new DownloadOutput("Unable to make map directory"));
        }
        return Optional.empty();
    }

    public static CompletableFuture<DownloadOutput> downloadMap(MapMetadata metadata) {
        Optional<DownloadOutput> oDO = MapDownloader.prepareDownloadPath(metadata);
        if (oDO.isPresent()) {
            return CompletableFuture.supplyAsync(() -> (DownloadOutput)oDO.get());
        }
        return Networking.downloadUserMap(metadata.mapID, metadata.locations.mapBasePath).thenApply(rsp -> {
            if (rsp != Networking.StatusCode.OK) {
                return new DownloadOutput("Error downloading map: (code " + rsp.name() + ")");
            }
            CompletableFuture<Networking.StatusCode> metaf = Networking.downloadMapMetadata(metadata.mapID, metadata.locations.mapBasePath);
            CompletableFuture<Networking.StatusCode> thumbf = Networking.downloadMapThumbnail(metadata.mapID, metadata.locations.mapBasePath);
            Networking.StatusCode meta = metaf.join();
            Networking.StatusCode thumb = thumbf.join();
            if (meta == Networking.StatusCode.OK && thumb == Networking.StatusCode.OK) {
                return new DownloadOutput((Networking.StatusCode)((Object)rsp));
            }
            FileUtils.deleteDirectory(new File(metadata.locations.mapBasePath));
            return new DownloadOutput("failed to download map use data");
        });
    }

    public static class DownloadOutput {
        public final Optional<String> reason;
        public final Optional<Networking.StatusCode> response;

        public DownloadOutput(String reason) {
            this.reason = Optional.of(reason);
            this.response = Optional.empty();
        }

        public DownloadOutput(Networking.StatusCode response) {
            this.reason = Optional.empty();
            this.response = Optional.of(response);
        }
    }
}

