/*
 * Decompiled with CFR 0.152.
 */
package group24.escaperoom.data;

import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.utils.GdxRuntimeException;
import group24.escaperoom.AssetManager;
import group24.escaperoom.data.MapMetadata;
import group24.escaperoom.data.MapSaver;
import group24.escaperoom.data.Networking;
import group24.escaperoom.utils.FileUtils;
import java.io.File;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

public class MapManager {
    public static Optional<Image> loadThumbNail(String path) {
        try {
            AssetManager.instance().load(path, Texture.class);
            AssetManager.instance().finishLoadingAsset(path);
            Image thumbnail = new Image(AssetManager.instance().get(path, Texture.class));
            return Optional.of(thumbnail);
        }
        catch (GdxRuntimeException gdxre) {
            System.err.println("failed to load thumbnail with path: " + path);
            return Optional.empty();
        }
    }

    public static CompletableFuture<Optional<String>> fetchThumbnail(MapMetadata metadata) {
        if (metadata.locations.isDownloaded) {
            return CompletableFuture.supplyAsync(() -> Optional.of(metadata.locations.mapThumbnailPath));
        }
        String dataDir = FileUtils.getAppDataDir();
        File tempDir = new File(dataDir + "/cache");
        if (!tempDir.exists() && !tempDir.mkdir()) {
            return CompletableFuture.supplyAsync(() -> Optional.empty());
        }
        File thumbnailFile = new File(dataDir + "/cache/" + metadata.mapID + "thumbnail.png");
        if (thumbnailFile.exists()) {
            return CompletableFuture.supplyAsync(() -> Optional.of(thumbnailFile.getAbsolutePath()));
        }
        return Networking.downloadMapThumbnail(metadata.mapID, tempDir.getAbsolutePath()).thenApply(s -> {
            if (s == Networking.StatusCode.OK) {
                File tempThumbnailFile = new File(tempDir, "thumbnail.png");
                if (!tempThumbnailFile.exists()) {
                    return Optional.empty();
                }
                tempThumbnailFile.renameTo(thumbnailFile);
                return Optional.of(thumbnailFile.getAbsolutePath());
            }
            return Optional.empty();
        });
    }

    public static Optional<MapMetadata> copy(MapMetadata from, String newName) {
        MapMetadata to = new MapMetadata(newName, false);
        if (new File(to.locations.mapBasePath).exists()) {
            return Optional.empty();
        }
        File mapDataPath = new File(from.locations.mapBasePath);
        File newMapDataPath = new File(to.locations.mapBasePath);
        if (!newMapDataPath.mkdirs()) {
            return Optional.empty();
        }
        if (!FileUtils.copyDirectory(mapDataPath.toPath(), newMapDataPath.toPath())) {
            return Optional.empty();
        }
        File oldMetaData = new File(to.locations.mapMetadataPath);
        if (!oldMetaData.delete()) {
            return Optional.empty();
        }
        if (!MapSaver.updateMetadata(to)) {
            return Optional.empty();
        }
        return Optional.of(to);
    }
}

