/*
 * Decompiled with CFR 0.152.
 */
package group24.escaperoom.data;

import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.JsonValue;
import com.badlogic.gdx.utils.JsonWriter;
import group24.escaperoom.data.GameSettings;
import group24.escaperoom.data.GameStatistics;
import group24.escaperoom.data.User;
import group24.escaperoom.utils.FileUtils;
import java.util.Optional;

public class MapMetadata
implements Json.Serializable {
    public String name = "";
    public String mapID = "";
    public MapLocation locations;
    public Optional<MapStats> stats = Optional.empty();
    public Optional<String> textureDirectory = Optional.empty();
    public Optional<String> objectDirectory = Optional.empty();
    public GameSettings gameSettings = new GameSettings();

    public MapMetadata(String name, boolean downloaded) {
        this.locations = new MapLocation(name, downloaded);
        this.name = name;
    }

    public boolean equals(Object obj) {
        if (obj instanceof MapMetadata) {
            MapMetadata other = (MapMetadata)MapMetadata.class.cast(obj);
            if (this.mapID.isEmpty() || other.mapID.isEmpty()) {
                return this.name.equals(other.name);
            }
            return this.mapID.equals(other.mapID);
        }
        return false;
    }

    public void setTextureDir(String absolutePath) {
        this.textureDirectory = Optional.of(absolutePath);
    }

    public void setObjectDir(String absolutePath) {
        this.objectDirectory = Optional.of(absolutePath);
    }

    public MapMetadata() {
    }

    @Override
    public void write(Json json) {
        json.setUsePrototypes(false);
        this.stats.ifPresent(s -> json.writeValue("stats", s));
        json.writeValue("game_settings", this.gameSettings);
        json.writeValue("id", this.mapID);
        json.writeValue("name", this.name);
    }

    @Override
    public void read(Json json, JsonValue jsonData) {
        this.mapID = jsonData.getString("id");
        this.name = jsonData.getString("name");
        JsonValue statsData = jsonData.get("stats");
        if (statsData != null) {
            this.stats = Optional.of(json.readValue(MapStats.class, statsData));
        }
        JsonValue settingsData = jsonData.get("game_settings");
        this.gameSettings = new GameSettings();
        if (settingsData != null) {
            this.gameSettings = json.readValue(GameSettings.class, settingsData);
        }
    }

    public String toString() {
        Json json = new Json();
        json.setOutputType(JsonWriter.OutputType.json);
        return json.toJson(this);
    }

    public static class MapLocation {
        public String folderName;
        public String mapBasePath;
        public String mapContentPath;
        public String mapMainFilePath;
        public String mapMetadataPath;
        public String mapThumbnailPath;
        public boolean isDownloaded;

        public MapLocation(String folderName, boolean isDownloaded) {
            this.folderName = folderName;
            this.isDownloaded = isDownloaded;
            this.mapBasePath = isDownloaded ? FileUtils.getAppDataDir() + "/maps/downloaded/" + folderName : FileUtils.getAppDataDir() + "/maps/local/" + folderName;
            this.mapContentPath = this.mapBasePath + "/content";
            this.mapMainFilePath = this.mapBasePath + "/content/mapdata.json";
            this.mapMetadataPath = this.mapBasePath + "/metadata.json";
            this.mapThumbnailPath = this.mapBasePath + "/thumbnail.png";
        }
    }

    public static class MapStats {
        public String creator;
        public String description;
        public long downloads = 0L;
        public long attempts = 0L;
        public long upvotes = 0L;
        public long downvotes = 0L;
        public long clears = 0L;
        public WorldRecord record = new WorldRecord();
        public GameStatistics clearStats;

        public static MapStats fromGameStats(GameStatistics gameStats) {
            MapStats ms = new MapStats();
            ms.creator = User.getCredentials().username;
            ms.description = "";
            ms.clearStats = gameStats;
            return ms;
        }

        public static class WorldRecord {
            public long fastestms = -1L;
            public String username = "No Record";
        }

        public static enum ValidStats {
            downloads,
            attempts,
            upvotes,
            downvotes;

        }
    }
}

