/*
 * Decompiled with CFR 0.152.
 */
package group24.escaperoom.data;

import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.JsonWriter;
import group24.escaperoom.data.Grid;
import group24.escaperoom.data.MapMetadata;
import group24.escaperoom.utils.FileUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.util.logging.Logger;

public class MapSaver {
    private static Logger log = Logger.getLogger(MapSaver.class.getName());

    private static boolean tryCreatePath(File file) {
        if (!file.exists()) {
            boolean created = true;
            try {
                created = file.createNewFile();
            }
            catch (Exception e) {
                log.warning("Unable to create file " + file.getAbsolutePath());
                e.printStackTrace();
                created = false;
            }
            if (!created) {
                return false;
            }
        }
        return true;
    }

    public static boolean updateMetadata(MapMetadata metadata) {
        File mapDir = new File(metadata.locations.mapBasePath);
        if (!FileUtils.tryCreateFolder(mapDir)) {
            return false;
        }
        return MapSaver.saveMetadata(metadata);
    }

    public static boolean deleteMap(MapMetadata metadata) {
        File mapDir = new File(metadata.locations.mapBasePath);
        return FileUtils.deleteDirectory(mapDir);
    }

    private static boolean saveMetadata(MapMetadata data) {
        try {
            File metaDataFile = new File(data.locations.mapMetadataPath);
            FileOutputStream fout = new FileOutputStream(metaDataFile);
            Json j = new Json();
            j.setOutputType(JsonWriter.OutputType.json);
            fout.write(j.toJson(data).getBytes());
            fout.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static boolean saveMap(Grid grid, MapMetadata metadata) {
        File mapDir = new File(FileUtils.getAppDataDir());
        if (!FileUtils.tryCreateFolder(mapDir)) {
            return false;
        }
        File dir = new File(metadata.locations.mapBasePath);
        if (!FileUtils.tryCreateFolder(dir)) {
            return false;
        }
        dir = new File(metadata.locations.mapContentPath);
        if (!FileUtils.tryCreateFolder(dir)) {
            return false;
        }
        File map = new File(metadata.locations.mapMainFilePath);
        if (!MapSaver.tryCreatePath(map)) {
            return false;
        }
        if (!MapSaver.saveMetadata(metadata)) {
            return false;
        }
        try {
            FileOutputStream fout = new FileOutputStream(map);
            Json j = new Json();
            j.setOutputType(JsonWriter.OutputType.json);
            fout.write(j.toJson(grid).getBytes());
            fout.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }
}

