/*
 * Decompiled with CFR 0.152.
 */
package group24.escaperoom.data;

import group24.escaperoom.data.MapMetadata;
import group24.escaperoom.data.Networking;
import group24.escaperoom.data.User;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

public class MapUploader {
    public static CompletableFuture<UploadOutput> uploadMap(MapMetadata metadata) {
        if (!User.isLoggedIn()) {
            return CompletableFuture.supplyAsync(() -> new UploadOutput("You must be logged in to upload a map!"));
        }
        if (metadata.stats.isEmpty()) {
            return CompletableFuture.supplyAsync(() -> new UploadOutput("uploadMap needs a metadata with present stats"));
        }
        String metadataString = metadata.toString();
        return Networking.uploadUserMap(metadata.locations, metadataString).thenApply(resp -> {
            if (resp.code != Networking.StatusCode.OK) {
                return new UploadOutput("Error uploading map: (code " + resp.code.name() + ")");
            }
            return new UploadOutput((Networking.UploadResponse)resp);
        });
    }

    public static class UploadOutput {
        public final Optional<String> reason;
        public final Optional<Networking.UploadResponse> response;

        public UploadOutput(String reason) {
            this.reason = Optional.of(reason);
            this.response = Optional.empty();
        }

        public UploadOutput(Networking.UploadResponse response) {
            this.reason = Optional.empty();
            this.response = Optional.of(response);
        }
    }
}

