/*
 * Decompiled with CFR 0.152.
 */
package group24.escaperoom.data;

import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.JsonReader;
import com.badlogic.gdx.utils.JsonValue;
import com.badlogic.gdx.utils.JsonWriter;
import group24.escaperoom.data.MapMetadata;
import group24.escaperoom.data.PlayerRecord;
import group24.escaperoom.data.Types;
import group24.escaperoom.data.User;
import group24.escaperoom.utils.Zip;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import javax.net.ssl.HttpsURLConnection;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;

public class Networking {
    private static final String BASE_API = "https://e9808rovje.execute-api.us-east-2.amazonaws.com/default";

    static CompletableFuture<RequestResponse> performRequest(String url, String method, boolean isAuthenticated) {
        RequestResponse rsp = new RequestResponse();
        if (isAuthenticated && !User.isLoggedIn()) {
            rsp.code = StatusCode.Forbidden;
            rsp.hasBody = false;
            return CompletableFuture.supplyAsync(() -> rsp);
        }
        CompletableFuture<RequestResponse> future = CompletableFuture.supplyAsync(() -> {
            HttpsURLConnection connection;
            int statusCode = 0;
            try {
                URL netUrl = URI.create(url).toURL();
                connection = (HttpsURLConnection)netUrl.openConnection();
                connection.setRequestMethod(method);
                if (isAuthenticated) {
                    User.Credentials creds = User.getCredentials();
                    connection.setRequestProperty("Authorization", String.format("%s@%s", creds.username, creds.access_key));
                }
                connection.setDoOutput(true);
                statusCode = connection.getResponseCode();
            }
            catch (Exception e) {
                rsp.code = StatusCode.InternalException;
                rsp.hasBody = false;
                rsp.body = null;
                System.out.println("errored (" + statusCode + "):");
                e.printStackTrace();
                return rsp;
            }
            try {
                rsp.body = connection.getInputStream();
                rsp.hasBody = true;
            }
            catch (Exception e) {
                rsp.body = null;
                rsp.hasBody = false;
            }
            rsp.code = StatusCode.FromInt(statusCode);
            return rsp;
        });
        return future;
    }

    public static CompletableFuture<RequestResponse> postJson(String url, String json, boolean isAuthenticated) {
        RequestResponse rsp = new RequestResponse();
        if (isAuthenticated && !User.isLoggedIn()) {
            System.out.println("you must be logged in to use this");
            rsp.code = StatusCode.Forbidden;
            rsp.hasBody = false;
            return CompletableFuture.supplyAsync(() -> rsp);
        }
        return CompletableFuture.supplyAsync(() -> {
            CloseableHttpClient httpClient = HttpClients.createDefault();
            HttpPost postRequest = new HttpPost(url);
            if (isAuthenticated) {
                User.Credentials creds = User.getCredentials();
                postRequest.setHeader("Authorization", String.format("%s@%s", creds.username, creds.access_key));
            }
            postRequest.setHeader("Content-Type", "application/json");
            postRequest.setEntity(new StringEntity(json, ContentType.APPLICATION_JSON));
            try {
                CloseableHttpResponse response = httpClient.execute(postRequest);
                HttpEntity httpResponse = response.getEntity();
                rsp.body = httpResponse.getContent();
                rsp.code = StatusCode.OK;
            }
            catch (IOException e) {
                rsp.code = StatusCode.InternalException;
                rsp.hasBody = false;
                rsp.body = null;
                System.out.println("errored (" + (Object)((Object)rsp.code) + "):");
                e.printStackTrace();
                return rsp;
            }
            rsp.hasBody = rsp.body != null;
            return rsp;
        });
    }

    public static CompletableFuture<RequestResponse> HttpMultipartPost(String url, MultipartFields fields, boolean isAuthenticated) {
        RequestResponse rsp = new RequestResponse();
        if (isAuthenticated && !User.isLoggedIn()) {
            System.out.println("you must be logged in to use this");
            rsp.code = StatusCode.Forbidden;
            rsp.hasBody = false;
            return CompletableFuture.supplyAsync(() -> rsp);
        }
        return CompletableFuture.supplyAsync(() -> {
            CloseableHttpClient httpClient = HttpClients.createDefault();
            HttpPost postRequest = new HttpPost(url);
            if (isAuthenticated) {
                User.Credentials creds = User.getCredentials();
                postRequest.setHeader("Authorization", String.format("%s@%s", creds.username, creds.access_key));
            }
            MultipartEntityBuilder builder = MultipartEntityBuilder.create();
            for (Map.Entry<String, String> pair : fields.strings.entrySet()) {
                builder.addTextBody(pair.getKey(), pair.getValue(), ContentType.TEXT_PLAIN);
            }
            try {
                for (Map.Entry<String, String> pair : fields.files.entrySet()) {
                    File f = new File(pair.getValue());
                    builder.addBinaryBody(pair.getKey(), new FileInputStream(f), ContentType.APPLICATION_OCTET_STREAM, f.getName());
                }
            }
            catch (FileNotFoundException e) {
                rsp.code = StatusCode.InternalException;
                rsp.hasBody = false;
                rsp.body = null;
                System.out.println("errored (" + (Object)((Object)rsp.code) + "):");
                e.printStackTrace();
                return rsp;
            }
            postRequest.setEntity(builder.build());
            try {
                CloseableHttpResponse response = httpClient.execute(postRequest);
                HttpEntity httpResponse = response.getEntity();
                rsp.body = httpResponse.getContent();
                rsp.code = StatusCode.OK;
            }
            catch (IOException e) {
                rsp.code = StatusCode.InternalException;
                rsp.hasBody = false;
                rsp.body = null;
                System.out.println("errored (" + (Object)((Object)rsp.code) + "):");
                e.printStackTrace();
                return rsp;
            }
            rsp.hasBody = rsp.body != null;
            return rsp;
        });
    }

    public static CompletableFuture<StatusCode> createUserAPI(User user, String password) {
        String url = "https://e9808rovje.execute-api.us-east-2.amazonaws.com/default/user/" + user.username + "/" + password;
        return Networking.performRequest(url, "POST", false).thenApply(rsp -> {
            if (rsp.code != StatusCode.OK) {
                return rsp.code;
            }
            if (!rsp.hasBody) {
                return StatusCode.InternalException;
            }
            JsonReader reader = new JsonReader();
            JsonValue val = reader.parse(rsp.body);
            val = val.get("user");
            user.player_id = UUID.fromString(val.getString("id"));
            user.access_key = UUID.fromString(val.getString("access_key"));
            return StatusCode.OK;
        });
    }

    public static CompletableFuture<StatusCode> attemptLoginAPI(User user, String password) {
        String url = "https://e9808rovje.execute-api.us-east-2.amazonaws.com/default/user/" + user.username + "/" + password;
        return Networking.performRequest(url, "GET", false).thenApply(rsp -> {
            if (rsp.code != StatusCode.OK) {
                return rsp.code;
            }
            if (!rsp.hasBody) {
                return StatusCode.InternalException;
            }
            JsonReader reader = new JsonReader();
            JsonValue val = reader.parse(rsp.body);
            val = val.get("user");
            user.player_id = UUID.fromString(val.getString("id"));
            user.access_key = UUID.fromString(val.getString("access_key"));
            return StatusCode.OK;
        });
    }

    public static CompletableFuture<StatusCode> userExists(User user) {
        return Networking.userExists(user.username);
    }

    public static CompletableFuture<StatusCode> userExists(String username) {
        String url = "https://e9808rovje.execute-api.us-east-2.amazonaws.com/default/user/" + username;
        return Networking.performRequest(url, "HEAD", false).thenApply(rsp -> rsp.code);
    }

    public static CompletableFuture<UploadResponse> uploadUserMap(MapMetadata.MapLocation locations, String metadata) {
        if (!User.isLoggedIn()) {
            return CompletableFuture.supplyAsync(() -> new UploadResponse(StatusCode.Forbidden));
        }
        if (!Zip.CreateArchive(locations.mapContentPath)) {
            System.err.printf("Failed to zip file `%s`\n", locations.mapContentPath);
            return CompletableFuture.supplyAsync(() -> new UploadResponse(StatusCode.InternalException));
        }
        MultipartFields fields = new MultipartFields();
        fields.strings.put("meta", metadata);
        fields.files.put("upload", String.format("%s.zip", locations.mapContentPath));
        fields.files.put("thumbnail", locations.mapThumbnailPath);
        return Networking.HttpMultipartPost(String.format("%s/map", BASE_API), fields, true).thenApply(rsp -> {
            if (rsp.code != StatusCode.OK) {
                System.err.println("Got non-200 status code from uploading map");
                return new UploadResponse(StatusCode.ServerException);
            }
            if (!rsp.hasBody) {
                System.err.println("Got no response body from uploading map");
                return new UploadResponse(StatusCode.ServerException);
            }
            JsonReader reader = new JsonReader();
            JsonValue val = reader.parse(rsp.body);
            String mapID = val.getString("map_id");
            new File(String.format("%s.zip", locations.mapContentPath)).delete();
            return new UploadResponse(StatusCode.OK, mapID);
        });
    }

    public static CompletableFuture<StatusCode> downloadUserMap(String mapID, String destination) {
        String url = "https://e9808rovje.execute-api.us-east-2.amazonaws.com/default/map/" + mapID;
        return Networking.performRequest(url, "GET", true).thenApply(rsp -> {
            if (rsp.code != StatusCode.OK) {
                System.err.printf("recieved non-200 response code: %s\n", rsp.code.toString());
                return rsp.code;
            }
            if (!rsp.hasBody) {
                System.err.println("response contained no body");
                return StatusCode.InternalException;
            }
            File mapDir = new File(destination);
            if (!mapDir.exists() || !mapDir.isDirectory()) {
                System.err.println("Map directory not found or not directory. Investigate immediately.");
                return StatusCode.InternalException;
            }
            try {
                File dl = File.createTempFile("mapdl", ".zip", mapDir);
                Files.copy(rsp.body, dl.toPath(), StandardCopyOption.REPLACE_EXISTING);
                if (!Zip.UnpackArchive(dl.getAbsolutePath(), mapDir)) {
                    System.err.println("unable to unzip archive");
                    return StatusCode.InternalException;
                }
                dl.delete();
            }
            catch (IOException e) {
                e.printStackTrace();
                return StatusCode.InternalException;
            }
            return StatusCode.OK;
        });
    }

    public static CompletableFuture<Types.ListMapsResponse> listMapMetadata(Types.ListMapsRequest request) {
        if (!User.isLoggedIn()) {
            return CompletableFuture.supplyAsync(() -> new Types.ListMapsResponse(StatusCode.Forbidden));
        }
        String url = String.format("%s/map/metadata", BASE_API);
        String requestQuery = request.toString();
        if (requestQuery.length() > 0) {
            url = url + "?" + requestQuery;
        }
        return Networking.performRequest(url, "GET", true).thenApply(rsp -> {
            if (rsp.code != StatusCode.OK) {
                System.out.println("List map response recieved a non-200 code: " + rsp.code.toString());
                return new Types.ListMapsResponse(rsp.code);
            }
            if (!rsp.hasBody) {
                System.out.println("List map returned no body. Treating as error.");
                return new Types.ListMapsResponse(StatusCode.InternalException);
            }
            Array<MapMetadata> mapMeta = new Array<MapMetadata>();
            try {
                JsonReader reader = new JsonReader();
                JsonValue val = reader.parse(rsp.body);
                val = val.get("metadata");
                Json json = new Json();
                for (JsonValue v : val) {
                    mapMeta.add(json.readValue(MapMetadata.class, v));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                return new Types.ListMapsResponse(StatusCode.InternalException);
            }
            return new Types.ListMapsResponse(StatusCode.OK, mapMeta);
        });
    }

    public static CompletableFuture<Types.ListPlayerRecordResponse> listPlayerRecords(Types.ListPlayerRecordRequest request) {
        if (!User.isLoggedIn()) {
            return CompletableFuture.supplyAsync(() -> new Types.ListPlayerRecordResponse(StatusCode.Forbidden));
        }
        String url = String.format("%s/leaderboard/users", BASE_API);
        String requestQuery = request.toString();
        if (requestQuery.length() > 0) {
            url = url + "?" + requestQuery;
        }
        return Networking.performRequest(url, "GET", true).thenApply(rsp -> {
            if (rsp.code != StatusCode.OK) {
                System.out.println("List map response recieved a non-200 code: " + rsp.code.toString());
                return new Types.ListPlayerRecordResponse(rsp.code);
            }
            if (!rsp.hasBody) {
                System.out.println("List map returned no body. Treating as error.");
                return new Types.ListPlayerRecordResponse(StatusCode.InternalException);
            }
            Array<PlayerRecord> records = new Array<PlayerRecord>();
            try {
                JsonReader reader = new JsonReader();
                JsonValue val = reader.parse(rsp.body);
                val = val.get("records");
                Json json = new Json();
                for (JsonValue v : val) {
                    records.add(json.readValue(PlayerRecord.class, v));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                return new Types.ListPlayerRecordResponse(StatusCode.InternalException);
            }
            return new Types.ListPlayerRecordResponse(StatusCode.OK, records);
        });
    }

    public static CompletableFuture<StatusCode> sendMapClear(String mapID, long clearTime) {
        if (!User.isLoggedIn()) {
            return CompletableFuture.supplyAsync(() -> StatusCode.Forbidden);
        }
        String url = String.format("%s/map/%s/clear/%d", BASE_API, mapID, clearTime);
        return Networking.performRequest(url, "POST", true).thenApply(rsp -> {
            if (rsp.code != StatusCode.OK) {
                System.err.printf("Failed to send map clear, got code %s\n", rsp.code.toString());
            }
            return rsp.code;
        });
    }

    public static CompletableFuture<StatusCode> updateMapStats(String mapID, Array<MapMetadata.MapStats.ValidStats> stats) {
        if (!User.isLoggedIn()) {
            return CompletableFuture.supplyAsync(() -> StatusCode.Forbidden);
        }
        StringBuilder sb = new StringBuilder();
        for (MapMetadata.MapStats.ValidStats stat : stats) {
            if (sb.length() == 0) {
                sb.append(stat.toString());
                continue;
            }
            sb.append('&');
            sb.append(stat.toString());
        }
        String url = String.format("%s/map/%s/stat?%s", BASE_API, mapID, sb.toString());
        return Networking.performRequest(url, "POST", true).thenApply(rsp -> {
            if (rsp.code != StatusCode.OK) {
                System.err.printf("Failed to send map clear, got code %s\n", rsp.code.toString());
            }
            return rsp.code;
        });
    }

    public static CompletableFuture<StatusCode> downloadMapMetadata(String mapID, String destination) {
        if (!User.isLoggedIn()) {
            System.out.println("you must be logged in to use this");
            return CompletableFuture.supplyAsync(() -> StatusCode.Forbidden);
        }
        String url = String.format("%s/map/%s/metadata", BASE_API, mapID);
        return Networking.performRequest(url, "GET", true).thenApply(rsp -> {
            MapMetadata metadata;
            if (rsp.code != StatusCode.OK) {
                System.err.printf("Failed to get map metadata, got code %s\n", rsp.code.toString());
                return rsp.code;
            }
            try {
                JsonReader reader = new JsonReader();
                JsonValue val = reader.parse(rsp.body);
                val = val.get("metadata");
                Json json = new Json();
                metadata = json.readValue(MapMetadata.class, val);
            }
            catch (Exception e) {
                e.printStackTrace();
                return StatusCode.InternalException;
            }
            try {
                File metaDataFile = new File(destination + "/metadata.json");
                FileOutputStream fout = new FileOutputStream(metaDataFile);
                Json j = new Json();
                j.setOutputType(JsonWriter.OutputType.json);
                fout.write(j.toJson(metadata).getBytes());
                fout.close();
            }
            catch (Exception e) {
                e.printStackTrace();
                return StatusCode.InternalException;
            }
            return rsp.code;
        });
    }

    public static CompletableFuture<StatusCode> downloadMapThumbnail(String mapID, String destination) {
        if (!User.isLoggedIn()) {
            System.out.println("you must be logged in to use this");
            return CompletableFuture.supplyAsync(() -> StatusCode.Forbidden);
        }
        String url = String.format("%s/map/%s/thumbnail", BASE_API, mapID);
        return Networking.performRequest(url, "GET", true).thenApply(rsp -> {
            if (rsp.code != StatusCode.OK) {
                System.err.printf("Failed to get map thumbnail, got code %s\n", rsp.code.toString());
                return rsp.code;
            }
            File dl = new File(destination + "/thumbnail.png");
            try {
                if (!dl.createNewFile()) {
                    System.err.printf("Failed to create thumbnail for map %s\n", mapID);
                    return StatusCode.InternalException;
                }
                Files.copy(rsp.body, dl.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                e.printStackTrace();
                return StatusCode.InternalException;
            }
            return rsp.code;
        });
    }

    public static CompletableFuture<StatusCode> updatePlayerRecord(PlayerRecord record) {
        if (!User.isLoggedIn()) {
            return CompletableFuture.supplyAsync(() -> StatusCode.Forbidden);
        }
        return Networking.postJson(String.format("%s/leaderboard/user", BASE_API), record.toString(), true).thenApply(rsp -> {
            if (rsp.code != StatusCode.OK) {
                System.err.println("Got non-200 status code from posting player record");
                JsonReader reader = new JsonReader();
                JsonValue val = reader.parse(rsp.body);
                String msg = val.getString("msg");
                System.out.println("msg:" + msg);
                return StatusCode.ServerException;
            }
            if (!rsp.hasBody) {
                System.err.println("Got no response body from updating player record");
                return StatusCode.ServerException;
            }
            return rsp.code;
        });
    }

    public static CompletableFuture<Types.PlayerRecordResponse> getPlayerRecord(String username) {
        if (!User.isLoggedIn()) {
            return CompletableFuture.supplyAsync(() -> new Types.PlayerRecordResponse(StatusCode.Forbidden));
        }
        String url = String.format("%s/leaderboard/user/%s", BASE_API, username);
        return Networking.performRequest(url, "GET", true).thenApply(rsp -> {
            if (rsp.code != StatusCode.OK) {
                System.err.println("Got non-200 status code from getting player record: " + rsp.code.name());
                return new Types.PlayerRecordResponse(rsp.code);
            }
            if (!rsp.hasBody) {
                System.err.println("Got no response body from uploading map");
                return new Types.PlayerRecordResponse(StatusCode.ServerException);
            }
            try {
                JsonReader reader = new JsonReader();
                JsonValue val = reader.parse(rsp.body);
                val = val.get("record");
                Json json = new Json();
                PlayerRecord r = json.readValue(PlayerRecord.class, val);
                return new Types.PlayerRecordResponse(rsp.code, r);
            }
            catch (Exception e) {
                e.printStackTrace();
                return new Types.PlayerRecordResponse(StatusCode.ServerException);
            }
        });
    }

    private static class RequestResponse {
        StatusCode code;
        boolean hasBody;
        InputStream body;

        private RequestResponse() {
        }
    }

    public static enum StatusCode {
        CodeUnknown,
        InternalException,
        ServerException,
        NoSuchUser,
        UserAlreadyExists,
        PageMissing,
        WrongPassword,
        Forbidden,
        OK;


        public static StatusCode FromInt(int code) {
            switch (code) {
                case 200: {
                    return OK;
                }
                case 400: {
                    return NoSuchUser;
                }
                case 401: {
                    return Forbidden;
                }
                case 403: {
                    return WrongPassword;
                }
                case 404: {
                    return PageMissing;
                }
                case 409: {
                    return UserAlreadyExists;
                }
                case 500: {
                    return ServerException;
                }
            }
            return CodeUnknown;
        }
    }

    private static class MultipartFields {
        HashMap<String, String> strings = new HashMap();
        HashMap<String, String> files = new HashMap();

        private MultipartFields() {
        }
    }

    public static class UploadResponse {
        public StatusCode code;
        public String mapID;

        public UploadResponse(StatusCode code) {
            this.code = code;
            this.mapID = null;
        }

        public UploadResponse(StatusCode code, String mapID) {
            this.code = code;
            this.mapID = mapID;
        }
    }
}

