/*
 * Decompiled with CFR 0.152.
 */
package group24.escaperoom.data;

import com.badlogic.gdx.Gdx;
import group24.escaperoom.data.Notification;
import java.util.HashSet;

public class NotificationBus {
    private static final NotificationBus inst = new NotificationBus();
    private final HashSet<NotificationListener> listeners = new HashSet();

    public static NotificationBus get() {
        return inst;
    }

    public void addListener(NotificationListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(NotificationListener listener) {
        this.listeners.remove(listener);
    }

    public void post(Notification notification) {
        Gdx.app.postRunnable(() -> {
            for (NotificationListener l : this.listeners) {
                l.onNotify(notification);
            }
        });
    }

    public static interface NotificationListener {
        public void onNotify(Notification var1);
    }
}

