/*
 * Decompiled with CFR 0.152.
 */
package group24.escaperoom.data;

import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.JsonReader;
import com.badlogic.gdx.utils.JsonValue;
import com.badlogic.gdx.utils.JsonWriter;
import group24.escaperoom.utils.FileUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.util.HashSet;
import java.util.logging.Logger;

public class RecordManager {
    Logger log = Logger.getLogger(RecordManager.class.getName());
    private static RecordManager recordManager;
    private String manifestPath;
    private ClearManifest manifest = new ClearManifest();

    private RecordManager() {
        File manifestFile;
        File recordDir = new File(FileUtils.getAppDataDir(), "record");
        if (!recordDir.exists()) {
            recordDir.mkdir();
        }
        if (!(manifestFile = new File(recordDir, "manifest.json")).exists()) {
            try {
                manifestFile.createNewFile();
            }
            catch (IOException ioe) {
                this.log.severe("Failed to create record manifest file...");
            }
        }
        this.manifestPath = manifestFile.getAbsolutePath();
        try {
            String jsonStr = Files.readString(manifestFile.toPath());
            JsonReader reader = new JsonReader();
            JsonValue jsonValue = reader.parse(jsonStr);
            this.manifest.read(new Json(), jsonValue);
        }
        catch (IOException ioe) {
            this.log.severe("Failed to read record manifest file...");
        }
        catch (Exception e) {
            this.log.severe("Failed to parse record manifest file...");
        }
    }

    public static RecordManager get() {
        if (recordManager == null) {
            recordManager = new RecordManager();
        }
        return recordManager;
    }

    public boolean registerClear(String mapID) {
        if (this.manifest.contains(mapID)) {
            return false;
        }
        this.manifest.add(mapID);
        return this.saveManifest();
    }

    private boolean saveManifest() {
        File f = new File(this.manifestPath);
        if (!f.exists()) {
            return false;
        }
        try {
            FileOutputStream fout = new FileOutputStream(f);
            Json j = new Json();
            j.setOutputType(JsonWriter.OutputType.json);
            fout.write(j.toJson(this.manifest).getBytes());
            fout.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public int getUniqueClears() {
        return this.manifest.size();
    }

    private static class ClearManifest
    extends HashSet<String>
    implements Json.Serializable {
        private ClearManifest() {
        }

        @Override
        public void write(Json json) {
            json.writeArrayStart("cleared");
            for (String id : this) {
                json.writeValue(id);
            }
            json.writeArrayEnd();
        }

        @Override
        public void read(Json json, JsonValue jsonData) {
            JsonValue completed = jsonData.get("cleared");
            if (completed != null) {
                for (JsonValue v : completed) {
                    this.add(v.asString());
                }
            }
        }
    }
}

