/*
 * Decompiled with CFR 0.152.
 */
package group24.escaperoom.data;

import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.Array;
import group24.escaperoom.data.MapMetadata;
import group24.escaperoom.data.Networking;
import group24.escaperoom.data.PlayerRecord;
import java.util.Optional;

public class Types {

    public static class IntVector2 {
        public int x;
        public int y;

        public IntVector2(int x, int y) {
            this.x = x;
            this.y = y;
        }

        public IntVector2(float x, float y) {
            this.x = MathUtils.floor(x);
            this.y = MathUtils.floor(y);
        }

        public IntVector2() {
            this.x = 0;
            this.y = 0;
        }

        public String toString() {
            return "(" + this.x + ", " + this.y + ")";
        }

        public boolean equals(Object obj) {
            if (obj instanceof IntVector2) {
                IntVector2 iv2 = (IntVector2)obj;
                return iv2.x == this.x && iv2.y == this.y;
            }
            return false;
        }

        public boolean contained(int minX, int minY, int maxX, int maxY) {
            return this.x >= minX && this.y >= minY && this.x <= maxX && this.y <= maxY;
        }

        public Vector2 asVector2() {
            return new Vector2(this.x, this.y);
        }

        public static IntVector2 fromVector2(Vector2 vector) {
            return new IntVector2(vector.x, vector.y);
        }

        public IntVector2 cpy() {
            return new IntVector2(this.x, this.y);
        }

        public IntVector2 dst() {
            return new IntVector2(this.x, this.y);
        }

        public IntVector2 add(IntVector2 other) {
            this.x += other.x;
            this.y += other.y;
            return this;
        }

        public IntVector2 add(int x, int y) {
            this.x += x;
            this.y += y;
            return this;
        }

        public IntVector2 set(int x, int y) {
            this.x = x;
            this.y = y;
            return this;
        }

        public IntVector2 set(float x, float y) {
            return this.set((int)x, (int)y);
        }

        public boolean equals(int x, int y) {
            return this.x == x && this.y == y;
        }

        public boolean equals(float x, float y) {
            return this.equals((int)x, (int)y);
        }

        public IntVector2 sub(IntVector2 other) {
            this.x -= other.x;
            this.y -= other.y;
            return this;
        }

        public IntVector2 sub(int x, int y) {
            this.x -= x;
            this.y -= y;
            return this;
        }
    }

    public static class ListMapsRequest
    extends ListableRequest {

        public static enum Field implements IsField
        {
            Username(FilterConstType.String),
            Downloads(FilterConstType.Integer),
            Attempts(FilterConstType.Integer),
            UpVotes(FilterConstType.Integer),
            DownVotes(FilterConstType.Integer),
            FastestTime(FilterConstType.String),
            RecordHolder(FilterConstType.String);

            private FilterConstType constType;

            public String toString() {
                switch (this) {
                    case Attempts: {
                        return "stats.attempts";
                    }
                    case DownVotes: {
                        return "stats.downvotes";
                    }
                    case Downloads: {
                        return "stats.downloads";
                    }
                    case FastestTime: {
                        return "stats.record.fastestms";
                    }
                    case Username: {
                        return "stats.creator";
                    }
                    case RecordHolder: {
                        return "stats.record.username";
                    }
                    case UpVotes: {
                        return "stats.upvotes";
                    }
                }
                return "";
            }

            private Field(FilterConstType constType) {
                this.constType = constType;
            }

            @Override
            public FilterConstType getConstType() {
                return this.constType;
            }

            @Override
            public String AsJsonKey() {
                return this.toString();
            }

            @Override
            public String displayName() {
                return this.name();
            }

            @Override
            public IsField[] getValues() {
                return Field.values();
            }

            @Override
            public IsField defaultSort() {
                return Username;
            }
        }
    }

    public static class ListPlayerRecordRequest
    extends ListableRequest {

        public static enum Field implements IsField
        {
            Username(FilterConstType.String),
            Attempts(FilterConstType.Integer),
            Clears(FilterConstType.Integer),
            UniqueClears(FilterConstType.Integer);

            private FilterConstType constType;

            public String toString() {
                switch (this) {
                    case Attempts: {
                        return "attempts";
                    }
                    case Username: {
                        return "username";
                    }
                    case Clears: {
                        return "clears";
                    }
                    case UniqueClears: {
                        return "uniqueClears";
                    }
                }
                return "";
            }

            private Field(FilterConstType constType) {
                this.constType = constType;
            }

            @Override
            public FilterConstType getConstType() {
                return this.constType;
            }

            @Override
            public String AsJsonKey() {
                return this.toString();
            }

            @Override
            public String displayName() {
                return this.name();
            }

            @Override
            public IsField[] getValues() {
                return Field.values();
            }

            @Override
            public IsField defaultSort() {
                return UniqueClears;
            }
        }
    }

    public static enum FilterConstType {
        String,
        Integer;

    }

    public static interface IsField {
        public String AsJsonKey();

        public FilterConstType getConstType();

        public String displayName();

        public IsField[] getValues();

        public IsField defaultSort();
    }

    public static abstract class ListableRequest {
        protected Optional<Filters> filters = Optional.empty();
        protected Optional<Sort> sort = Optional.empty();
        protected Optional<Integer> limit = Optional.empty();

        public String toString() {
            StringBuilder sb = new StringBuilder();
            this.filters.ifPresent(f -> sb.append(f.toString()));
            this.sort.ifPresent(s -> {
                if (sb.length() != 0) {
                    sb.append("&");
                }
                sb.append(s.toString());
            });
            this.limit.ifPresent(l -> {
                if (sb.length() != 0) {
                    sb.append("&");
                }
                sb.append("limit=");
                sb.append(l);
            });
            return sb.toString();
        }

        public ListableRequest withSort(Sort s) {
            this.sort = Optional.of(s);
            return this;
        }

        public ListableRequest withFilters(Filter ... filters) {
            this.filters = Optional.of(new Filters(filters));
            return this;
        }

        public ListableRequest withFilters(Filters filters) {
            this.filters = Optional.of(filters);
            return this;
        }

        public ListableRequest withLimit(int limit) {
            this.limit = Optional.of(limit);
            return this;
        }
    }

    public static class Sort {
        private String field;
        private Optional<Direction> direction;

        public String toString() {
            if (this.direction.isPresent()) {
                return String.format("sort_field=%s&sort_dir=%s", this.field, this.direction.get().toString());
            }
            return String.format("sort_field=%s", this.field);
        }

        public Sort(String field) {
            this.field = field;
            this.direction = Optional.empty();
        }

        public Sort(String field, Direction direction) {
            this.field = field;
            this.direction = Optional.of(direction);
        }

        public static enum Direction {
            Ascending,
            Descending;


            public String toString() {
                switch (this) {
                    case Ascending: {
                        return "asc";
                    }
                    case Descending: {
                        return "desc";
                    }
                }
                return "null";
            }
        }
    }

    public static class Filter {
        private String field;
        private Method method;
        private Optional<String> sconst;
        private Optional<Integer> iconst;

        public String toString() {
            if (this.sconst.isPresent()) {
                return String.format("filter_field=%s&filter_method=%s&filter_value=%s&filter_type=str", this.field, this.method.toString(), this.sconst.get());
            }
            return String.format("filter_field=%s&filter_method=%s&filter_value=%s&filter_type=int", this.field, this.method.toString(), this.iconst.get());
        }

        public Method getMethod() {
            return this.method;
        }

        public String getField() {
            return this.field;
        }

        public Filter(String field, Method method, String value) {
            this.field = field;
            this.method = method;
            this.sconst = Optional.of(value);
            this.iconst = Optional.empty();
        }

        public Filter(String field, Method method, Integer value) {
            this.field = field;
            this.method = method;
            this.sconst = Optional.empty();
            this.iconst = Optional.of(value);
        }

        public static enum Method {
            LessThanEqualTo,
            LessThan,
            Equals,
            NotEquals,
            GreaterThan,
            GreaterThanEqualTo;


            public String toString() {
                switch (this) {
                    case Equals: {
                        return "eq";
                    }
                    case GreaterThan: {
                        return "gt";
                    }
                    case GreaterThanEqualTo: {
                        return "gte";
                    }
                    case LessThan: {
                        return "lt";
                    }
                    case LessThanEqualTo: {
                        return "lte";
                    }
                    case NotEquals: {
                        return "ne";
                    }
                }
                return "null";
            }
        }
    }

    public static class Filters {
        private Array<Filter> filters = new Array();
        private Optional<Combination> combination = Optional.empty();

        public String toString() {
            StringBuilder sb = new StringBuilder();
            for (Filter filter : this.filters) {
                if (sb.length() != 0) {
                    sb.append("&");
                }
                sb.append(filter.toString());
            }
            if (this.filters.size > 1) {
                this.combination.ifPresent(combo -> {
                    if (sb.length() != 0) {
                        sb.append("&");
                    }
                    sb.append("filters_approach=");
                    sb.append(combo.toString());
                });
            }
            return sb.toString();
        }

        public Filters(Combination combination, Filter ... filters) {
            this.combination = Optional.of(combination);
            this.filters = Array.with(filters);
        }

        public Filters(Filter ... filters) {
            this.combination = Optional.empty();
            this.filters = Array.with(filters);
        }

        public static enum Combination {
            And,
            Or;


            public String toString() {
                switch (this) {
                    case And: {
                        return "and";
                    }
                    case Or: {
                        return "or";
                    }
                }
                return "null";
            }
        }
    }

    public static class ListMapsResponse {
        public Networking.StatusCode code;
        public Array<MapMetadata> metadata;

        public ListMapsResponse(Networking.StatusCode code) {
            this.code = code;
            this.metadata = null;
        }

        public ListMapsResponse(Networking.StatusCode code, Array<MapMetadata> metadata) {
            this.code = code;
            this.metadata = metadata;
        }
    }

    public static class ListPlayerRecordResponse {
        public Networking.StatusCode code;
        public Array<PlayerRecord> records;

        public ListPlayerRecordResponse(Networking.StatusCode code) {
            this.code = code;
            this.records = null;
        }

        public ListPlayerRecordResponse(Networking.StatusCode code, Array<PlayerRecord> metadata) {
            this.code = code;
            this.records = metadata;
        }
    }

    public static class PlayerRecordResponse {
        public Networking.StatusCode code;
        public PlayerRecord record;

        public PlayerRecordResponse(Networking.StatusCode code) {
            this.code = code;
            this.record = null;
        }

        public PlayerRecordResponse(Networking.StatusCode code, PlayerRecord record) {
            this.code = code;
            this.record = record;
        }
    }
}

