/*
 * Decompiled with CFR 0.152.
 */
package group24.escaperoom.data;

import group24.escaperoom.data.Networking;
import group24.escaperoom.data.PlayerRecord;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;

public class User {
    private static User current = new User();
    protected String username;
    protected UUID player_id;
    protected UUID access_key;
    protected PlayerRecord record;

    public static PlayerRecord getRecord() {
        return User.current.record;
    }

    private User() {
    }

    public static Credentials getCredentials() {
        return new Credentials(User.current.username, User.current.access_key);
    }

    public static CompletableFuture<Networking.StatusCode> AttemptLogin(String username, String password) {
        User.current.username = username;
        return Networking.attemptLoginAPI(current, password).thenCompose(code -> {
            if (code != Networking.StatusCode.OK) {
                return CompletableFuture.supplyAsync(() -> code);
            }
            return Networking.getPlayerRecord(User.current.username).thenApply(prr -> {
                if (prr.code == Networking.StatusCode.PageMissing) {
                    User.current.record = new PlayerRecord();
                    User.current.record.username = User.current.username;
                    return Networking.StatusCode.OK;
                }
                if (prr.code == Networking.StatusCode.OK) {
                    User.current.record = prr.record;
                }
                return prr.code;
            });
        });
    }

    public static void logOut() {
        User.current.username = null;
        User.current.access_key = null;
        User.current.player_id = null;
    }

    public static CompletableFuture<Networking.StatusCode> createAccount(String username, String password) {
        User.current.username = username;
        return Networking.createUserAPI(current, password);
    }

    public static CompletableFuture<Networking.StatusCode> hasAccount(String username) {
        return Networking.userExists(username);
    }

    public static boolean isLoggedIn() {
        return User.current.access_key != null;
    }

    public static class Credentials {
        public String username;
        public UUID access_key;

        private Credentials(String username, UUID access_key) {
            this.username = username;
            this.access_key = access_key;
        }
    }
}

