/*
 * Decompiled with CFR 0.152.
 */
package group24.escaperoom.entities;

import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.math.Vector2;
import group24.escaperoom.AssetManager;
import group24.escaperoom.entities.properties.TiledBrushable;
import group24.escaperoom.utils.Types;

public class FowTile {
    public static FowTile[][] fowTiles;
    public static Types.Size gridSize;
    TiledBrushable.TileType inner = TiledBrushable.TileType.CENTER;
    int textureOriginX;
    int textureOriginY;
    public TextureAtlas.AtlasRegion texture = new TextureAtlas.AtlasRegion(AssetManager.instance().getRegion("fow_tilemap"));

    public FowTile() {
        this.textureOriginX = this.texture.getRegionX();
        this.textureOriginY = this.texture.getRegionY();
        Types.Size offset = this.inner.getOffset();
        this.setRegion(offset.width, offset.height, 16, 16);
    }

    public void setRegion(int x, int y, int width, int height) {
        this.texture.setRegion(this.textureOriginX + x, this.textureOriginY + y, width, height);
    }

    public void setOrientation(TiledBrushable.TileType tileType) {
        this.inner = tileType;
        Types.Size offset = this.inner.getOffset();
        this.setRegion(offset.width, offset.height, 16, 16);
    }

    private int getAdjancencies(boolean[][] revealed, Vector2 position, boolean recurse) {
        int adjancencies = 0;
        int checked = 0;
        for (int yoff = 1; yoff >= -1; --yoff) {
            for (int xoff = -1; xoff <= 1; ++xoff) {
                if (xoff == 0 && yoff == 0) continue;
                Vector2 pos = position.cpy();
                pos.x += (float)xoff;
                pos.y += (float)yoff;
                if (pos.x < 0.0f || pos.x >= (float)FowTile.gridSize.width || pos.y < 0.0f || pos.y >= (float)FowTile.gridSize.height) {
                    adjancencies |= 1 << 7 - checked;
                    ++checked;
                    continue;
                }
                if (!revealed[(int)pos.y][(int)pos.x]) {
                    adjancencies |= 1 << 7 - checked;
                }
                ++checked;
                if (!recurse) continue;
                this.updateTiles(revealed, pos, false);
            }
        }
        return adjancencies;
    }

    public void updateTiles(boolean[][] revealed, Vector2 position, boolean recurse) {
        if (!revealed[(int)position.y][(int)position.x]) {
            FowTile tilable = fowTiles[(int)position.y][(int)position.x];
            switch (this.getAdjancencies(revealed, position, recurse)) {
                case 11: 
                case 15: 
                case 43: 
                case 47: 
                case 139: 
                case 143: 
                case 171: 
                case 175: {
                    tilable.setOrientation(TiledBrushable.TileType.BLOCK_TL);
                    break;
                }
                case 31: 
                case 63: 
                case 159: 
                case 191: {
                    tilable.setOrientation(TiledBrushable.TileType.BLOCK_T);
                    break;
                }
                case 22: 
                case 23: 
                case 54: 
                case 55: 
                case 150: 
                case 151: 
                case 182: 
                case 183: {
                    tilable.setOrientation(TiledBrushable.TileType.BLOCK_TR);
                    break;
                }
                case 107: 
                case 111: 
                case 235: 
                case 239: {
                    tilable.setOrientation(TiledBrushable.TileType.BLOCK_L);
                    break;
                }
                case 255: {
                    tilable.setOrientation(TiledBrushable.TileType.CENTER);
                    break;
                }
                case 214: 
                case 215: 
                case 246: 
                case 247: {
                    tilable.setOrientation(TiledBrushable.TileType.BLOCK_R);
                    break;
                }
                case 104: 
                case 105: 
                case 108: 
                case 109: 
                case 232: 
                case 233: 
                case 236: 
                case 237: {
                    tilable.setOrientation(TiledBrushable.TileType.BLOCK_BL);
                    break;
                }
                case 248: 
                case 249: 
                case 252: 
                case 253: {
                    tilable.setOrientation(TiledBrushable.TileType.BLOCK_B);
                    break;
                }
                case 208: 
                case 209: 
                case 212: 
                case 213: 
                case 240: 
                case 241: 
                case 244: 
                case 245: {
                    tilable.setOrientation(TiledBrushable.TileType.BLOCK_BR);
                    break;
                }
                case 127: {
                    tilable.setOrientation(TiledBrushable.TileType.BLOCK_NO_TL);
                    break;
                }
                case 223: {
                    tilable.setOrientation(TiledBrushable.TileType.BLOCK_NO_TR);
                    break;
                }
                case 251: {
                    tilable.setOrientation(TiledBrushable.TileType.BLOCK_NO_BL);
                    break;
                }
                case 254: {
                    tilable.setOrientation(TiledBrushable.TileType.BLOCK_NO_BR);
                    break;
                }
                case 8: 
                case 9: 
                case 12: 
                case 13: 
                case 40: 
                case 41: 
                case 44: 
                case 45: 
                case 136: 
                case 140: 
                case 141: 
                case 168: 
                case 169: 
                case 172: 
                case 173: {
                    tilable.setOrientation(TiledBrushable.TileType.LINE_CAP_L);
                    break;
                }
                case 16: 
                case 17: 
                case 20: 
                case 21: 
                case 48: 
                case 49: 
                case 52: 
                case 53: 
                case 144: 
                case 145: 
                case 148: 
                case 149: 
                case 176: 
                case 177: 
                case 180: 
                case 181: {
                    tilable.setOrientation(TiledBrushable.TileType.LINE_CAP_R);
                    break;
                }
                case 24: 
                case 25: 
                case 28: 
                case 29: 
                case 56: 
                case 57: 
                case 60: 
                case 61: 
                case 152: 
                case 153: 
                case 156: 
                case 157: 
                case 184: 
                case 185: 
                case 188: 
                case 189: {
                    tilable.setOrientation(TiledBrushable.TileType.LINE_HORI);
                    break;
                }
                case 2: 
                case 3: 
                case 6: 
                case 7: 
                case 34: 
                case 35: 
                case 38: 
                case 39: 
                case 130: 
                case 131: 
                case 134: 
                case 135: 
                case 162: 
                case 163: 
                case 166: 
                case 167: {
                    tilable.setOrientation(TiledBrushable.TileType.LINE_CAP_T);
                    break;
                }
                case 64: 
                case 65: 
                case 68: 
                case 69: 
                case 96: 
                case 97: 
                case 100: 
                case 101: 
                case 192: 
                case 193: 
                case 196: 
                case 197: 
                case 224: 
                case 225: 
                case 228: 
                case 229: {
                    tilable.setOrientation(TiledBrushable.TileType.LINE_CAP_B);
                    break;
                }
                case 66: 
                case 67: 
                case 70: 
                case 71: 
                case 98: 
                case 99: 
                case 102: 
                case 103: 
                case 194: 
                case 195: 
                case 198: 
                case 199: 
                case 226: 
                case 227: 
                case 230: 
                case 231: {
                    tilable.setOrientation(TiledBrushable.TileType.LINE_VERT);
                    break;
                }
                case 82: 
                case 83: 
                case 114: 
                case 115: {
                    tilable.setOrientation(TiledBrushable.TileType.T_L);
                    break;
                }
                case 74: 
                case 78: 
                case 202: 
                case 206: {
                    tilable.setOrientation(TiledBrushable.TileType.T_R);
                    break;
                }
                case 88: 
                case 89: 
                case 92: 
                case 93: {
                    tilable.setOrientation(TiledBrushable.TileType.T_T);
                    break;
                }
                case 26: 
                case 58: 
                case 154: 
                case 186: {
                    tilable.setOrientation(TiledBrushable.TileType.T_B);
                    break;
                }
                case 90: {
                    tilable.setOrientation(TiledBrushable.TileType.PLUS);
                    break;
                }
                case 72: 
                case 73: 
                case 76: 
                case 77: 
                case 200: 
                case 201: 
                case 204: 
                case 205: {
                    tilable.setOrientation(TiledBrushable.TileType.CORNER_BL);
                    break;
                }
                case 10: 
                case 14: 
                case 42: 
                case 46: 
                case 138: 
                case 142: 
                case 170: 
                case 174: {
                    tilable.setOrientation(TiledBrushable.TileType.CORNER_TL);
                    break;
                }
                case 18: 
                case 19: 
                case 50: 
                case 51: 
                case 146: 
                case 147: 
                case 178: 
                case 179: {
                    tilable.setOrientation(TiledBrushable.TileType.CORNER_TR);
                    break;
                }
                case 80: 
                case 81: 
                case 84: 
                case 85: 
                case 112: 
                case 113: 
                case 116: 
                case 117: {
                    tilable.setOrientation(TiledBrushable.TileType.CORNER_BR);
                    break;
                }
                case 210: 
                case 211: 
                case 242: 
                case 243: {
                    tilable.setOrientation(TiledBrushable.TileType.RIGHT_CORNER_BL);
                    break;
                }
                case 106: 
                case 110: 
                case 234: 
                case 238: {
                    tilable.setOrientation(TiledBrushable.TileType.LEFT_CORNER_BR);
                    break;
                }
                case 120: 
                case 121: 
                case 124: 
                case 125: {
                    tilable.setOrientation(TiledBrushable.TileType.BOT_CORNER_TL);
                    break;
                }
                case 27: 
                case 59: 
                case 155: 
                case 187: {
                    tilable.setOrientation(TiledBrushable.TileType.TOP_CORNER_BL);
                    break;
                }
                case 75: 
                case 79: 
                case 203: 
                case 207: {
                    tilable.setOrientation(TiledBrushable.TileType.LEFT_CORNER_TR);
                    break;
                }
                case 86: 
                case 87: 
                case 118: 
                case 119: {
                    tilable.setOrientation(TiledBrushable.TileType.RIGHT_CORNER_TL);
                    break;
                }
                case 30: 
                case 62: 
                case 158: 
                case 190: {
                    tilable.setOrientation(TiledBrushable.TileType.TOP_CORNER_BR);
                    break;
                }
                case 216: 
                case 217: 
                case 220: 
                case 221: {
                    tilable.setOrientation(TiledBrushable.TileType.BOT_CORNER_TR);
                    break;
                }
                case 218: {
                    tilable.setOrientation(TiledBrushable.TileType.CORNER_NOT_TL);
                    break;
                }
                case 122: {
                    tilable.setOrientation(TiledBrushable.TileType.CORNER_NOT_TR);
                    break;
                }
                case 91: {
                    tilable.setOrientation(TiledBrushable.TileType.CORNER_NOT_BR);
                    break;
                }
                case 94: {
                    tilable.setOrientation(TiledBrushable.TileType.CORNER_NOT_BL);
                    break;
                }
                case 250: {
                    tilable.setOrientation(TiledBrushable.TileType.CORNER_DB_B);
                    break;
                }
                case 123: {
                    tilable.setOrientation(TiledBrushable.TileType.CORNER_DB_L);
                    break;
                }
                case 222: {
                    tilable.setOrientation(TiledBrushable.TileType.CORNER_DB_R);
                    break;
                }
                case 95: {
                    tilable.setOrientation(TiledBrushable.TileType.CORNER_DB_T);
                    break;
                }
                case 126: {
                    tilable.setOrientation(TiledBrushable.TileType.CORNER_DIAG_BR);
                    break;
                }
                case 219: {
                    tilable.setOrientation(TiledBrushable.TileType.CORNER_DIAG_TR);
                    break;
                }
                case 0: {
                    tilable.setOrientation(TiledBrushable.TileType.SOLO);
                    break;
                }
                default: {
                    tilable.setOrientation(TiledBrushable.TileType.CENTER);
                }
            }
        }
    }
}

