/*
 * Decompiled with CFR 0.152.
 */
package group24.escaperoom.entities;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.JsonReader;
import com.badlogic.gdx.utils.JsonValue;
import com.badlogic.gdx.utils.Null;
import group24.escaperoom.AssetManager;
import group24.escaperoom.data.Drawable;
import group24.escaperoom.data.GameContext;
import group24.escaperoom.data.Grid;
import group24.escaperoom.data.Types;
import group24.escaperoom.entities.objects.ObjectTypeData;
import group24.escaperoom.entities.player.PlayerAction;
import group24.escaperoom.entities.properties.AnimatedProperty;
import group24.escaperoom.entities.properties.ConnectorRelay;
import group24.escaperoom.entities.properties.ConnectorSource;
import group24.escaperoom.entities.properties.ContainsItemProperty;
import group24.escaperoom.entities.properties.ItemProperty;
import group24.escaperoom.entities.properties.ItemPropertyValue;
import group24.escaperoom.entities.properties.PropertyMap;
import group24.escaperoom.entities.properties.PropertyType;
import group24.escaperoom.entities.properties.SpinnableProperty;
import group24.escaperoom.entities.properties.Stylable;
import group24.escaperoom.entities.properties.TiledBrushable;
import group24.escaperoom.screens.GameScreen;
import group24.escaperoom.screens.MapScreen;
import group24.escaperoom.ui.editorTools.TiledBrush;
import group24.escaperoom.utils.Notifier;
import group24.escaperoom.utils.Types;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.logging.Logger;

public class Item
implements Json.Serializable,
Drawable {
    Logger log = Logger.getLogger(Item.class.getName());
    @Null
    public MapScreen map;
    Optional<BlockingParams> blockRegion = Optional.empty();
    static int nextID = 0;
    static TextureAtlas.AtlasRegion selectHighlight;
    boolean playerFocus;
    ObjectTypeData objectTypeData;
    JsonValue jsonData;
    boolean contained = false;
    public int id;
    TextureAtlas.AtlasRegion texture;
    public Types.IntVector2 position = new Types.IntVector2(0, 0);
    private int rotation = 0;
    public int renderPriority = 0;
    public boolean selected = false;
    private boolean highlight = false;
    private boolean dim = false;
    public boolean flipped = false;
    public boolean mirrorH = false;
    public boolean mirrorV = false;
    public Color color = new Color(1.0f, 1.0f, 1.0f, 1.0f);
    public Types.Size occupiedSize = new Types.Size(0, 0);
    public Types.Size itemSize = new Types.Size(0, 0);
    Types.IntVector2 textureOrigin;
    PropertyMap propertyMap = new PropertyMap();

    public Item() {
        if (selectHighlight == null) {
            selectHighlight = AssetManager.instance().getRegion("selection_outline");
        }
        this.texture = AssetManager.instance().getRegion("placeholder");
        this.id = nextID++;
    }

    public Item(ObjectTypeData typeData) {
        this.initItem(typeData);
    }

    public void initItem(ObjectTypeData typeData) {
        this.objectTypeData = typeData;
        this.position = new Types.IntVector2(0, 0);
        this.itemSize = this.objectTypeData.size.copy();
        this.occupiedSize = this.itemSize.copy();
        this.renderPriority = this.objectTypeData.renderPriority;
        this.setTexture(new TextureAtlas.AtlasRegion(AssetManager.instance().getRegion(this.objectTypeData.texture)));
        this.objectTypeData.propertyParameters.forEach((prop, propParams) -> {
            ItemProperty<? extends ItemPropertyValue> p = prop.getEmptyProperty();
            if (p == null) {
                Notifier.error(String.format("Tried to load invalid property on item %s", typeData.name));
                return;
            }
            p.setOwner(this);
            p.read(new Json(), (JsonValue)propParams);
            this.addProperty(p);
        });
        PropertyMap.applyCallbacks();
    }

    @Override
    public void write(Json json) {
        int tile_depth;
        json.writeValue("item_name", this.objectTypeData.name);
        json.writeValue("type_category", this.objectTypeData.category);
        json.writeValue("is_contained", this.contained);
        json.writeValue("id", this.id);
        json.writeValue("width", this.itemSize.width);
        json.writeValue("height", this.itemSize.height);
        json.writeValue("x", this.position.x);
        json.writeValue("y", this.position.y);
        json.writeValue("rotation", this.getRotation());
        json.writeValue("flipped", this.flipped);
        json.writeValue("texture", this.objectTypeData.texture);
        json.writeValue("mirror_h", this.mirrorH);
        json.writeValue("mirror_v", this.mirrorV);
        try {
            tile_depth = this.map.getTileDepthOf(this);
        }
        catch (Exception e) {
            tile_depth = -1;
        }
        json.writeValue("tile_depth", tile_depth);
        json.writeValue("render_priority", this.objectTypeData.renderPriority);
        json.writeArrayStart("properties");
        this.propertyMap.write(json);
        json.writeArrayEnd();
    }

    @Override
    public void read(Json json, JsonValue jsonData) {
        this.jsonData = jsonData;
        String typeCategory = jsonData.getString("type_category");
        String item_name = jsonData.getString("item_name");
        int width = jsonData.getInt("width");
        int height = jsonData.getInt("height");
        int render_priority = jsonData.getInt("render_priority");
        String texture = jsonData.getString("texture");
        this.objectTypeData = new ObjectTypeData(item_name, typeCategory, new Types.Size(width, height), texture, render_priority, null);
        this.id = jsonData.getInt("id");
        if (this.id >= nextID) {
            nextID = this.id + 1;
        }
        this.setTexture(new TextureAtlas.AtlasRegion(AssetManager.instance().getRegion(this.objectTypeData.texture)));
        this.setRotation(jsonData.getInt("rotation"));
        this.itemSize = this.objectTypeData.size.copy();
        this.contained = jsonData.getBoolean("is_contained", false);
        this.mirrorH = jsonData.getBoolean("mirror_h", false);
        this.mirrorV = jsonData.getBoolean("mirror_v", false);
        this.occupiedSize = this.objectTypeData.size.copy();
        this.flipped = jsonData.getBoolean("flipped");
        if (this.flipped) {
            this.flip();
            this.flipped = true;
        }
        this.renderPriority = this.objectTypeData.renderPriority;
        this.position.x = jsonData.getInt("x");
        this.position.y = jsonData.getInt("y");
        this.propertyMap.readWrapper(this, json, jsonData.get("properties"));
    }

    public String printString() {
        return new Json().prettyPrint(this);
    }

    public void update(float delta) {
        this.getProperty(PropertyType.Animated, AnimatedProperty.class).ifPresent(a -> a.maybeAdvance(delta));
        if (this.map instanceof GameScreen) {
            this.getProperty(PropertyType.ConnectorSource, ConnectorSource.class).ifPresent(csp -> csp.propagate(new GameContext((GameScreen)this.map), new HashSet<Integer>()));
            this.getProperty(PropertyType.ConnectorRelay, ConnectorRelay.class).ifPresent(csp -> csp.propagate(new GameContext((GameScreen)this.map), new HashSet<Integer>()));
        }
    }

    public void reloadTexture() {
        this.setTexture(new TextureAtlas.AtlasRegion(AssetManager.instance().getRegion(this.objectTypeData.texture)));
        for (ItemProperty<? extends ItemPropertyValue> p : this.getProperties()) {
            p.updateTexture();
        }
    }

    public Item clone() {
        return this.clone(false);
    }

    public Item clone(boolean preserveID) {
        Item i = new Item();
        int newID = i.getID();
        this.jsonData = new JsonReader().parse(new Json().toJson(this));
        i.read(new Json(), this.jsonData);
        if (preserveID) {
            --nextID;
        } else {
            i.id = newID;
        }
        return i;
    }

    public Item copy() {
        Item newItem = new Item();
        newItem.initItem(this.getType());
        this.propertyMap.forEach((t, p) -> newItem.addProperty(p.cloneProperty(newItem)));
        return newItem;
    }

    public String getItemName() {
        if (this.hasProperty(PropertyType.Stylable)) {
            return this.getProperty(PropertyType.Stylable, Stylable.class).get().getCurrentValue().getStyleName() + " " + this.objectTypeData.name;
        }
        return this.objectTypeData.name;
    }

    public Array<PlayerAction> getPlayerActions(GameContext ctx) {
        Array<PlayerAction> actions = new Array<PlayerAction>();
        for (ItemProperty<? extends ItemPropertyValue> p : this.getProperties()) {
            actions.addAll(p.getActions(ctx));
        }
        return actions;
    }

    public void adjustTextureRegion(int x, int y, int width, int height) {
        this.texture.setRegion(this.textureOrigin.x + x, this.textureOrigin.y + y, width, height);
    }

    private void gainFocus() {
        this.setSelected(true);
    }

    private void loseFocus() {
        this.setSelected(false);
    }

    public String toString() {
        return this.getItemName();
    }

    public boolean equals(Object obj) {
        if (Item.class.isInstance(obj)) {
            return ((Item)Item.class.cast(obj)).getID() == this.getID();
        }
        return false;
    }

    public void remove(boolean temporary) {
        if (this.map != null) {
            if (!temporary && this.hasProperty(PropertyType.ContainsItemsProperty)) {
                this.getProperty(PropertyType.ContainsItemsProperty, ContainsItemProperty.class).ifPresent(cip -> cip.getCurrentValues().forEach(ci -> {
                    Item contained = ci.getItem();
                    if (contained == null || !contained.isContained() || this.map.itemIsPlaced(contained)) {
                        return;
                    }
                    this.map.grid.items.remove(ci.getItem().getID());
                }));
            }
            this.map.removeItemFromGrid(this, temporary);
            this.getProperty(PropertyType.TiledBrushable, TiledBrushable.class).ifPresent(tbp -> TiledBrush.updateSurroundingTiles(this.getPosition().cpy(), this.map, this));
        }
    }

    public void remove() {
        this.remove(false);
    }

    public void addProperty(ItemProperty<? extends ItemPropertyValue> property) {
        this.propertyMap.put(property.getType(), property);
    }

    public void removeProperty(PropertyType type) {
        this.propertyMap.remove((Object)type);
    }

    public boolean hasProperty(PropertyType type) {
        return this.propertyMap.containsKey((Object)type);
    }

    public Collection<ItemProperty<? extends ItemPropertyValue>> getProperties() {
        return this.propertyMap.values();
    }

    public Optional<ItemProperty<? extends ItemPropertyValue>> getProperty(PropertyType type) {
        ItemProperty prop = (ItemProperty)this.propertyMap.get((Object)type);
        return prop == null ? Optional.empty() : Optional.of(prop);
    }

    public <T extends ItemPropertyValue, P extends ItemProperty<T>> Optional<P> getProperty(PropertyType type, Class<P> expectedClass) {
        ItemProperty prop;
        try {
            prop = (ItemProperty)expectedClass.cast(this.propertyMap.get((Object)type));
        }
        catch (Exception e) {
            return Optional.empty();
        }
        return prop == null ? Optional.empty() : Optional.of(prop);
    }

    public Array<ItemProperty<? extends ItemPropertyValue>> getProperties(PropertyType ... types) {
        Array<ItemProperty<? extends ItemPropertyValue>> ps = new Array<ItemProperty<? extends ItemPropertyValue>>();
        for (PropertyType type : types) {
            ItemProperty p = (ItemProperty)this.propertyMap.get((Object)type);
            if (p == null) continue;
            ps.add(p);
        }
        return ps;
    }

    public void mirrorHorizontal() {
        this.mirrorH = !this.mirrorH;
    }

    public void setRenderPriority(int priority) {
        this.renderPriority = priority;
        this.objectTypeData.renderPriority = priority;
    }

    public void setWidth(int width) {
        this.itemSize.width = width;
        this.objectTypeData.size.width = width;
        if (this.flipped) {
            this.occupiedSize.height = width;
        } else {
            this.occupiedSize.width = width;
        }
    }

    public void setHeight(int height) {
        this.itemSize.height = height;
        this.objectTypeData.size.height = height;
        if (this.flipped) {
            this.occupiedSize.width = height;
        } else {
            this.occupiedSize.height = height;
        }
    }

    public void increaseRenderPriotity() {
        ++this.renderPriority;
        ++this.objectTypeData.renderPriority;
    }

    public void decreaseRenderPriotity() {
        this.renderPriority = Math.max(0, this.renderPriority - 1);
        this.objectTypeData.renderPriority = Math.max(0, this.renderPriority - 1);
    }

    public void mirrorVertical() {
        this.mirrorV = !this.mirrorV;
    }

    private void preMove() {
        this.remove(true);
    }

    private void postMove() {
        if (this.map != null) {
            this.map.placeItem(this);
            TiledBrush.updateSurroundingTiles(this.getPosition(), this.map, this);
        }
    }

    public void setHighlighed(boolean highlighted) {
        this.highlight = highlighted;
    }

    public void setDimmed(boolean dimmed) {
        this.dim = dimmed;
    }

    public void setPosition(Types.IntVector2 pos) {
        this.setPosition(pos.x, pos.y);
    }

    public void setPosition(int x, int y) {
        this.position.x = x;
        this.position.y = y;
    }

    public void moveTo(int x, int y) {
        if (this.position.x == x && this.position.y == y) {
            return;
        }
        this.preMove();
        this.setPosition(x, y);
        this.postMove();
    }

    public void setBlocksPlayer(float offsetX, float offsetY, float blockWidth, float blockHeight) {
        this.blockRegion = Optional.of(new BlockingParams(offsetX, offsetY, new Vector2(blockWidth, blockHeight)));
    }

    public void setTexture(TextureAtlas.AtlasRegion region) {
        this.textureOrigin = new Types.IntVector2(region.getRegionX(), region.getRegionY());
        this.texture = region;
        this.objectTypeData.texture = region.name;
    }

    public void setFocus(boolean isFocused) {
        this.playerFocus = isFocused;
        if (this.playerFocus) {
            this.gainFocus();
        } else {
            this.loseFocus();
        }
    }

    public void setContained(boolean isContained) {
        this.contained = isContained;
    }

    public void setBlocksPlayer(boolean blocksPlayer) {
        this.blockRegion = blocksPlayer ? Optional.of(new BlockingParams(0.0f, 0.0f, new Vector2(this.occupiedSize.width, this.occupiedSize.height))) : Optional.empty();
    }

    public void setSelected(boolean isSelected) {
        this.selected = isSelected;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setColor(float r, float b, float g, float a) {
        this.color.set(r, g, b, a);
    }

    public void setAlpha(float alpha) {
        this.color.a = alpha;
    }

    public float getAlpha() {
        return this.color.a;
    }

    private void preRotate() {
        this.remove(true);
    }

    public void setRotation(int degrees) {
        if (this.trySpin(degrees)) {
            return;
        }
        int oldRotation = this.getRotation();
        this.preRotate();
        this.rotation = degrees %= 360;
        this.postRotate(oldRotation);
    }

    public void rotateBy(int degrees) {
        int oldRotation = this.getRotation();
        int newRotation = (oldRotation + (degrees %= 360)) % 360;
        this.setRotation(newRotation);
    }

    private void postRotate(int oldRotation) {
        this.maybeFlip();
        if (this.map != null) {
            if (this.map.canPlace(this, this.position)) {
                this.map.placeItem(this);
            } else {
                this.setRotation(oldRotation);
            }
        }
    }

    public void flip() {
        int oldTileHeight = this.getHeight();
        int oldTileWidth = this.getWidth();
        this.occupiedSize.width = oldTileHeight;
        this.occupiedSize.height = oldTileWidth;
        this.flipped = !this.flipped;
    }

    private boolean trySpin(float degrees) {
        if (!this.hasProperty(PropertyType.Spinable)) {
            return false;
        }
        SpinnableProperty sp = this.getProperty(PropertyType.Spinable, SpinnableProperty.class).get();
        int prevRotation = this.getRotation();
        this.preRotate();
        sp.setSpin(SpinnableProperty.degreesToSpinCount(degrees %= 360.0f));
        this.postRotate(prevRotation);
        return true;
    }

    private void maybeFlip() {
        float degrees = this.getRotation();
        if (!(this.flipped || (degrees %= 360.0f) != 90.0f && degrees != 270.0f)) {
            this.flip();
        } else if (this.flipped && (degrees == 180.0f || degrees == 0.0f)) {
            this.flip();
        }
    }

    public int getX() {
        switch (this.rotation) {
            case 0: 
            case 90: {
                return this.position.x;
            }
            case 180: 
            case 270: {
                return this.position.x - this.occupiedSize.width + 1;
            }
        }
        return this.position.x;
    }

    public int getY() {
        switch (this.rotation) {
            case 0: 
            case 270: {
                return this.position.y;
            }
            case 90: 
            case 180: {
                return this.position.y - this.occupiedSize.height + 1;
            }
        }
        return this.position.y;
    }

    public Optional<Rectangle> blockingRegion() {
        return this.blockRegion.map(bp -> new Rectangle((float)this.getX() + bp.offsetX, (float)this.getY() + bp.offsetY, bp.blockSize.x, bp.blockSize.y));
    }

    public TextureAtlas.AtlasRegion getTexture() {
        return this.texture;
    }

    public Rectangle getOccupiedRegion() {
        return new Rectangle(this.getX(), this.getY(), this.getWidth(), this.getHeight());
    }

    public Types.IntVector2 getPosition() {
        return new Types.IntVector2(this.getX(), this.getY());
    }

    public ObjectTypeData getType() {
        return this.objectTypeData;
    }

    public Types.Size getOccupiedSize() {
        return this.occupiedSize;
    }

    public int getID() {
        return this.id;
    }

    public int getHeight() {
        return this.occupiedSize.height;
    }

    public int getWidth() {
        return this.occupiedSize.width;
    }

    public boolean isContained() {
        return this.contained;
    }

    public int getRotation() {
        return this.getProperty(PropertyType.Spinable, SpinnableProperty.class).map(p -> p.getSpinCount() * 90).orElse(this.rotation);
    }

    public float getDrawRotation() {
        if (this.hasProperty(PropertyType.Spinable)) {
            return 0.0f;
        }
        return 360 - this.rotation;
    }

    @Override
    public int renderPriority() {
        return this.renderPriority;
    }

    @Override
    public Vector2 position() {
        return this.getPosition().asVector2();
    }

    @Override
    public int getTileDepth() {
        return Grid.current().getTileDepthOf(this);
    }

    private Types.IntVector2 mirrorOffsets() {
        Types.IntVector2 ofst = new Types.IntVector2(0, 0);
        if (this.mirrorH) {
            ofst.x = this.itemSize.width;
        }
        if (this.mirrorV) {
            ofst.y = this.itemSize.height;
        }
        return ofst;
    }

    private Types.IntVector2 mirrorFactors() {
        Types.IntVector2 facts = new Types.IntVector2(1, 1);
        if (this.mirrorH) {
            facts.x = -1;
        }
        if (this.mirrorV) {
            facts.y = -1;
        }
        return facts;
    }

    @Override
    public void draw(Batch batch) {
        Color drawColor = this.color.cpy();
        if (this.dim) {
            drawColor.a = 0.2f;
        }
        if (this.highlight) {
            drawColor.a = 1.0f;
        }
        batch.setColor(drawColor);
        Types.IntVector2 mirOfsts = this.mirrorOffsets();
        Types.IntVector2 mirFct = this.mirrorFactors();
        batch.draw(this.texture, this.position.x + mirOfsts.x, this.position.y + mirOfsts.y, 0.5f - (float)mirOfsts.x, 0.5f - (float)mirOfsts.y, this.itemSize.width * mirFct.x, this.itemSize.height * mirFct.y, 1.0f, 1.0f, this.getDrawRotation());
        if (this.selected) {
            batch.setColor(1.0f, 1.0f, 1.0f, 0.75f);
            batch.draw(selectHighlight, this.position.x + mirOfsts.x, this.position.y + mirOfsts.y, 0.5f - (float)mirOfsts.x, 0.5f - (float)mirOfsts.y, this.itemSize.width * mirFct.x, this.itemSize.height * mirFct.y, 1.0f, 1.0f, this.getDrawRotation());
        }
        batch.setColor(1.0f, 1.0f, 1.0f, 1.0f);
    }

    private class BlockingParams {
        float offsetX = 0.0f;
        float offsetY = 0.0f;
        Vector2 blockSize;

        private BlockingParams(float oX, float oY, float w, float h) {
            this(oX, oY, new Vector2(w, h));
        }

        private BlockingParams(float oX, float oY, Vector2 dims) {
            this.offsetX = oX;
            this.offsetY = oY;
            this.blockSize = dims;
        }
    }
}

