/*
 * Decompiled with CFR 0.152.
 */
package group24.escaperoom.entities.objects;

import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.JsonReader;
import com.badlogic.gdx.utils.JsonValue;
import group24.escaperoom.entities.Item;
import group24.escaperoom.entities.properties.PropertyType;
import group24.escaperoom.utils.Types;
import java.io.Serializable;
import java.util.HashMap;

public class ObjectTypeData
implements Serializable,
Json.Serializable {
    public String name;
    public String category;
    public Types.Size size;
    public String texture;
    public HashMap<PropertyType, JsonValue> propertyParameters = new HashMap();
    public int renderPriority;

    public ObjectTypeData(String name, String category, Types.Size size, String texture, int renderPriority, HashMap<PropertyType, JsonValue> propertyParameters) {
        this.init(name, category, size, texture, renderPriority, propertyParameters);
    }

    public ObjectTypeData() {
    }

    private void init(String name, String category, Types.Size size, String texture, int renderPriority, HashMap<PropertyType, JsonValue> propertyParameters) {
        this.name = name;
        this.category = category;
        this.size = size;
        this.renderPriority = renderPriority;
        this.texture = texture;
        if (propertyParameters != null) {
            this.propertyParameters.putAll(propertyParameters);
        }
    }

    public ObjectTypeData copy() {
        return new ObjectTypeData(new String(this.name), new String(this.category), this.size.copy(), new String(this.texture), this.renderPriority, this.propertyParameters == null ? new HashMap<PropertyType, JsonValue>() : new HashMap<PropertyType, JsonValue>(this.propertyParameters));
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object other) {
        if (!(other instanceof ObjectTypeData)) {
            return false;
        }
        ObjectTypeData that = (ObjectTypeData)other;
        return this.name.equals(that.name) && this.size.equals(that.size) && this.texture.equals(that.texture) && this.renderPriority == that.renderPriority && this.propertyParameters.equals(that.propertyParameters);
    }

    @Override
    public void write(Json json) {
        json.writeValue("name", this.name);
        json.writeObjectStart("size");
        json.writeValue("width", this.size.width);
        json.writeValue("height", this.size.height);
        json.writeObjectEnd();
        Item item = new Item(this);
        json.writeArrayStart("properties");
        for (PropertyType type : this.propertyParameters.keySet()) {
            json.writeValue(type.asJsonString());
        }
        json.writeArrayEnd();
        json.writeObjectStart("property_values");
        item.getProperties().forEach(prop -> json.writeValue(prop.getType().asJsonString(), prop));
        json.writeObjectEnd();
        json.writeValue("texture", this.texture + ".png");
        json.writeValue("render_priority", this.renderPriority);
    }

    @Override
    public void read(Json json, JsonValue jsonData) {
        String name = jsonData.getString("name");
        JsonValue sz = jsonData.get("size");
        Types.Size size = new Types.Size(sz.getInt("width"), sz.getInt("height"));
        HashMap<PropertyType, JsonValue> validProperties = new HashMap<PropertyType, JsonValue>();
        JsonValue properties = jsonData.get("properties");
        JsonValue propertyValues = jsonData.get("property_values");
        properties.forEach(prop -> validProperties.put(PropertyType.fromString(prop.toString()), new JsonReader().parse("{}")));
        if (propertyValues != null) {
            properties.forEach(prop -> {
                JsonValue params = propertyValues.get(prop.toString());
                if (params != null) {
                    validProperties.put(PropertyType.fromString(prop.toString()), params);
                }
            });
        }
        String texture = jsonData.getString("texture");
        int render_priority = jsonData.getInt("render_priority", 1);
        String texture_id = texture.substring(0, texture.lastIndexOf(".png"));
        this.init(name, this.category, size, texture_id, render_priority, validProperties);
    }
}

