/*
 * Decompiled with CFR 0.152.
 */
package group24.escaperoom.entities.player;

import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.math.Circle;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.utils.Array;
import group24.escaperoom.control.ControlsManager;
import group24.escaperoom.control.Input;
import group24.escaperoom.data.Drawable;
import group24.escaperoom.data.GameContext;
import group24.escaperoom.data.GameEvent;
import group24.escaperoom.data.GameEventBus;
import group24.escaperoom.data.GameStatistics;
import group24.escaperoom.entities.Item;
import group24.escaperoom.entities.player.PlayerAction;
import group24.escaperoom.entities.player.PlayerDetails;
import group24.escaperoom.entities.properties.InteractableProperty;
import group24.escaperoom.entities.properties.PropertyType;
import group24.escaperoom.screens.GameScreen;
import group24.escaperoom.ui.PlayerInventoryDialog;
import group24.escaperoom.utils.Collisions;
import java.util.HashSet;
import java.util.Optional;

public class Player
extends Actor
implements Drawable {
    public GameStatistics.PlayerStatistics stats = new GameStatistics.PlayerStatistics();
    Vector2 startPos;
    Vector2 velocity;
    boolean movementProcessed = false;
    TextureAtlas.AtlasRegion texture;
    HashSet<Integer> obtainedItems = new HashSet();
    public int renderPriority = 5;
    int originX;
    int prevX = -1;
    GameScreen gameScreen;
    int prevFrameX = -1;
    Direction moveDir = Direction.Standing;
    Direction lastMoveDir = Direction.South;
    Vector2 lastPosition = new Vector2();
    int moveState = 0;
    float lastFrameCheck = 0.0f;
    private PlayerDetails details;
    private int width = 2;
    private int height = 2;
    private static final float INTERACT_RANGE = 2.0f;
    private Array<Item> inventory;
    private HashSet<Integer> inventoryIDs = new HashSet();
    private Array<Item> focusCanidates = new Array();
    private Optional<Integer> focusedItem = Optional.empty();
    private Actor room;
    private boolean inventoryOpen = false;
    private Optional<PlayerInventoryDialog> dialog = Optional.empty();

    public GameScreen getGameScreen() {
        return this.gameScreen;
    }

    public Direction getDirection() {
        return this.lastMoveDir;
    }

    public void setDetails(PlayerDetails details) {
        this.details = details;
    }

    public void setSize(int width, int height) {
        this.width = width;
        this.height = height;
        this.setWidth(width);
        this.setHeight(height);
    }

    public void setTexture(TextureAtlas.AtlasRegion texture) {
        this.texture = texture;
        this.originX = texture.getRegionX();
    }

    @Override
    public void act(float delta) {
        super.act(delta);
        this.move(delta);
        this.findInteractables();
    }

    @Override
    public void setPosition(float x, float y) {
        super.setPosition(x, y);
        this.startPos = new Vector2(x, y);
    }

    public void calculateStatistics(GameStatistics stats) {
        this.stats.avgSpeed = this.stats.distanceTraveled / (float)(stats.timeMilliseconds / 1000L);
        stats.player = this.stats;
    }

    public Player(int x, int y, GameScreen game) {
        this.startPos = new Vector2(x, y);
        this.inventory = new Array();
        this.velocity = new Vector2(0.0f, 0.0f);
        this.gameScreen = game;
        GameEventBus.get().addListener(ev -> this.addItemToInventory(ev.source), ev -> ev.type == GameEvent.EventType.ItemObtained);
        this.setPosition(x, y);
        this.setWidth(this.width);
        this.setHeight(this.height);
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        batch.draw(this.texture, this.getX(), this.getY(), this.getWidth(), this.getHeight());
    }

    public int getRenderPriority() {
        return this.renderPriority;
    }

    public Vector2 getPosition() {
        return new Vector2(this.getX(), this.getY());
    }

    public Vector2 getCenter() {
        return new Vector2(this.getX(1), this.getY(1));
    }

    public void findInteractables() {
        final class Canidate {
            Item i;
            float dst;

            Canidate(Item i, float dst) {
                this.i = i;
                this.dst = dst;
            }
        }
        Array<Canidate> candiates = new Array<Canidate>();
        Optional<Item> currItem = this.getFocusedItem();
        this.focusCanidates.forEach(i -> i.setSelected(false));
        this.focusCanidates.clear();
        GameContext ctx = new GameContext(this.gameScreen, this);
        Vector2 center = this.getCenter();
        for (Item item : this.gameScreen.itemsNear(this.getCenter(), 2.0f)) {
            if (!item.hasProperty(PropertyType.Interactable)) continue;
            Vector2 point = Collisions.getNearestPoint(item.getOccupiedRegion(), this.getCenter());
            float dst = point.dst2(center);
            Array<PlayerAction> actions = item.getPlayerActions(ctx);
            if (actions.isEmpty()) continue;
            candiates.add(new Canidate(item, dst));
        }
        candiates.sort((a, b) -> Float.compare(a.dst, b.dst));
        candiates.forEach(c -> this.focusCanidates.add(c.i));
        if (this.focusCanidates.isEmpty()) {
            this.focusedItem = Optional.empty();
            return;
        }
        if (currItem.isPresent() && this.lastPosition.equals(this.getPosition()) && this.focusCanidates.contains(currItem.get(), false)) {
            this.focusedItem = Optional.of(this.focusCanidates.indexOf(currItem.get(), false));
            this.focusCanidates.get(this.focusedItem.get()).setFocus(true);
        } else {
            this.focusedItem = Optional.of(0);
            this.focusCanidates.first().setFocus(true);
        }
    }

    public Array<Item> getFocusCanidates() {
        return this.focusCanidates;
    }

    public Optional<Item> getFocusedItem() {
        return this.focusedItem.flatMap(i -> {
            if (i >= 0 && i < this.focusCanidates.size) {
                return Optional.of(this.focusCanidates.get((int)i));
            }
            return Optional.empty();
        });
    }

    public void openInventory() {
        if (!this.inventoryOpen) {
            this.inventoryOpen = true;
            PlayerInventoryDialog d = new PlayerInventoryDialog(this);
            this.dialog = Optional.of(d);
            d.show(this.getGameScreen().getUIStage());
        }
    }

    public Array<Item> getInventory() {
        return this.inventory;
    }

    public HashSet<Integer> getInventoryIDs() {
        return this.inventoryIDs;
    }

    public void removeItemFromInventory(Item i) {
        this.inventory.removeValue(i, false);
        this.inventoryIDs.remove(i.getID());
        if (this.inventoryOpen) {
            this.dialog.ifPresent(d -> d.inventoryChanged());
        }
    }

    public void addItemToInventory(Item i) {
        if (!this.obtainedItems.contains(i.getID())) {
            ++this.stats.itemsCollected;
            this.obtainedItems.add(i.getID());
        }
        this.inventory.add(i);
        this.inventoryIDs.add(i.getID());
        i.setContained(true);
        if (this.inventoryOpen) {
            this.dialog.ifPresent(d -> d.inventoryChanged());
        }
    }

    public boolean isInventoryOpen() {
        return this.inventoryOpen;
    }

    public void setInventoryOpen(boolean isOpen) {
        this.inventoryOpen = isOpen;
        if (!isOpen) {
            this.dialog = Optional.empty();
        }
    }

    public void printInventory() {
        System.out.println("Items:");
        int ndx = 0;
        for (Item i : this.inventory) {
            System.out.println(String.format("  Item %s, id %d. slot %d", i.getItemName(), i.getID(), ndx));
        }
    }

    public void registerBinds() {
        this.registerMovementBinds();
        this.registerItemBinds();
    }

    private void registerMovementBinds() {
        ControlsManager.registerInput(Input.MOVE_UP, ControlsManager.InputType.HELD, () -> this.setMoveDir(0.0f, this.details.speed, Direction.North));
        ControlsManager.registerInput(Input.MOVE_DOWN, ControlsManager.InputType.HELD, () -> this.setMoveDir(0.0f, -this.details.speed, Direction.South));
        ControlsManager.registerInput(Input.MOVE_LEFT, ControlsManager.InputType.HELD, () -> this.setMoveDir(-this.details.speed, 0.0f, Direction.West));
        ControlsManager.registerInput(Input.MOVE_RIGHT, ControlsManager.InputType.HELD, () -> this.setMoveDir(this.details.speed, 0.0f, Direction.East));
    }

    private void setMoveDir(float x, float y, Direction dir) {
        if (this.movementProcessed) {
            return;
        }
        this.movementProcessed = true;
        this.velocity.set(x, y);
        this.moveDir = dir;
    }

    private void registerItemBinds() {
        ControlsManager.registerInput(Input.PRINT_INVENTORY, ControlsManager.InputType.PRESSED, this::printInventory);
        ControlsManager.registerInput(Input.INVENTORY, ControlsManager.InputType.PRESSED, this::openInventory);
        ControlsManager.registerInput(Input.INTERACT, ControlsManager.InputType.PRESSED, () -> this.focusedItem.ifPresent(i -> this.focusCanidates.get((int)i).getProperty(PropertyType.Interactable, InteractableProperty.class).ifPresent(prop -> prop.interact(new GameContext(this.gameScreen, this)))));
        ControlsManager.registerInput(Input.CHANGE_INTERACT_FOCUS, ControlsManager.InputType.PRESSED, () -> {
            this.focusedItem.ifPresent(i -> this.focusCanidates.get((int)i).setFocus(false));
            this.focusedItem = this.focusedItem.map(i -> (i + 1) % this.focusCanidates.size);
            this.focusedItem.ifPresent(i -> this.focusCanidates.get((int)i).setFocus(true));
        });
    }

    public void stepAnimation(float delta) {
        if (this.velocity.isZero()) {
            this.maybeAdvanceFrame(delta, this.details.textureInfo.idleFrameDelayMS, this.details.textureInfo.idleFrames);
            if (this.lastMoveDir != Direction.Standing && this.moveDir != Direction.Standing) {
                this.moveDir = Direction.Standing;
                this.lastFrameCheck = 0.0f;
                this.moveState = 0;
            }
            this.updateAnimationFrame();
            return;
        }
        if (this.moveDir != this.lastMoveDir) {
            this.lastMoveDir = this.moveDir;
            this.lastFrameCheck = 0.0f;
            this.moveState = 0;
            this.updateAnimationFrame();
            return;
        }
        this.maybeAdvanceFrame(delta, this.details.textureInfo.moveFrameDelayMS, this.details.textureInfo.movementFrames);
        this.updateAnimationFrame();
    }

    private void maybeAdvanceFrame(float delta, float frameDelay, int frameCount) {
        this.lastFrameCheck += delta;
        if (this.lastFrameCheck > frameDelay / 1000.0f) {
            this.lastFrameCheck = 0.0f;
            this.moveState = (this.moveState + 1) % frameCount;
        }
    }

    private void updateAnimationFrame() {
        int newFrameOffset = this.moveDir != Direction.Standing ? 4 * this.details.textureInfo.idleFrames + this.moveDir.ordinal() * this.details.textureInfo.movementFrames + this.moveState : this.lastMoveDir.ordinal() * this.details.textureInfo.idleFrames + this.moveState;
        int newFrameX = newFrameOffset * this.details.textureInfo.frameWidth;
        if (this.prevFrameX != newFrameX) {
            this.prevFrameX = newFrameX;
            this.texture.setRegion(this.originX + newFrameX, this.texture.getRegionY(), this.details.textureInfo.frameWidth, this.details.textureInfo.frameHeight);
        }
    }

    private void move(float delta) {
        if (this.room == null) {
            this.room = this.gameScreen.getRoot().findActor("room");
        }
        float newX = MathUtils.clamp(this.getX() + this.velocity.x * delta, this.room.getX(), this.room.getX() + this.room.getWidth() - this.getWidth());
        float newY = MathUtils.clamp(this.getY() + this.velocity.y * delta, this.room.getY(), this.room.getY() + this.room.getHeight() - this.getHeight());
        boolean canMove = true;
        Rectangle newPostition = new Rectangle(newX + this.details.hitboxInfo.xOffset, newY + this.details.hitboxInfo.yOffset, this.details.hitboxInfo.width, this.details.hitboxInfo.height);
        for (Item item : this.getGameScreen().itemsNear(new Circle(newX, newY, 3.0f))) {
            Optional<Rectangle> blockRegion = item.blockingRegion();
            if (!blockRegion.isPresent() || !blockRegion.get().overlaps(newPostition)) continue;
            canMove = false;
            break;
        }
        if (canMove) {
            this.stats.distanceTraveled += this.getPosition().dst(newX, newY);
            this.lastPosition.set(this.getX(), this.getY());
            this.setPosition(newX, newY);
        }
        this.velocity.setZero();
        this.movementProcessed = false;
    }

    public Rectangle getOccupiedRegion() {
        return new Rectangle(this.getX(), this.getY(), this.width, this.height);
    }

    @Override
    public int renderPriority() {
        return this.renderPriority;
    }

    @Override
    public void draw(Batch batch) {
        batch.draw(this.texture, this.getX(), this.getY(), this.getWidth(), this.getHeight());
    }

    @Override
    public Vector2 position() {
        return this.getPosition();
    }

    @Override
    public int getTileDepth() {
        return Integer.MAX_VALUE;
    }

    public static enum Direction {
        North,
        East,
        South,
        West,
        Standing;

    }
}

