/*
 * Decompiled with CFR 0.152.
 */
package group24.escaperoom.entities.player;

import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.JsonValue;

public class PlayerDetails
implements Json.Serializable {
    public HitboxInfo hitboxInfo = new HitboxInfo(0.0f, 0.0f, 32.0f, 32.0f);
    public float speed = 1.0f;
    public TextureInfo textureInfo = new TextureInfo(0, 1000, 1, 100, 32, 32);

    @Override
    public void write(Json json) {
        json.writeObjectStart("hitbox");
        json.writeValue("x_offset", Float.valueOf(this.hitboxInfo.xOffset));
        json.writeValue("y_offset", Float.valueOf(this.hitboxInfo.yOffset));
        json.writeValue("width", Float.valueOf(this.hitboxInfo.width));
        json.writeValue("height", Float.valueOf(this.hitboxInfo.height));
        json.writeObjectEnd();
        json.writeValue("speed", Float.valueOf(this.speed));
        json.writeObjectStart("texture");
        json.writeValue("idle_frames", this.textureInfo.idleFrames);
        json.writeValue("idle_frame_delay_ms", this.textureInfo.idleFrameDelayMS);
        json.writeValue("move_frames", this.textureInfo.movementFrames);
        json.writeValue("move_frame_delay_ms", this.textureInfo.moveFrameDelayMS);
        json.writeValue("frame_width", this.textureInfo.frameWidth);
        json.writeValue("frame_height", this.textureInfo.frameHeight);
        json.writeObjectEnd();
    }

    @Override
    public void read(Json json, JsonValue jsonData) {
        JsonValue hitbox = jsonData.get("hitbox");
        JsonValue texture = jsonData.get("texture");
        this.speed = jsonData.getFloat("speed", 5.0f);
        this.hitboxInfo = hitbox != null ? new HitboxInfo(hitbox.getFloat("x_offset", 0.25f), hitbox.getFloat("y_offset", 0.0f), hitbox.getFloat("width", 1.5f), hitbox.getFloat("height", 1.5f)) : new HitboxInfo(0.25f, 0.0f, 1.5f, 1.5f);
        this.textureInfo = texture != null ? new TextureInfo(texture.getInt("idle_frames", 1), texture.getInt("idle_frame_delay_ms", 1000), texture.getInt("move_frames", 4), texture.getInt("move_frame_delay_ms", 100), texture.getInt("frame_width", 32), texture.getInt("frame_height", 32)) : new TextureInfo(1, 1000, 4, 100, 32, 32);
    }

    public static class HitboxInfo {
        public float xOffset;
        public float yOffset;
        public float width;
        public float height;

        public HitboxInfo(float xOffset, float yOffset, float width, float height) {
            this.xOffset = xOffset;
            this.yOffset = yOffset;
            this.width = width;
            this.height = height;
        }
    }

    public static class TextureInfo {
        public int idleFrames;
        public int idleFrameDelayMS;
        public int movementFrames;
        public int moveFrameDelayMS;
        public int frameWidth;
        public int frameHeight;

        public TextureInfo(int idleFrames, int idleFrameDelayMS, int movementFrames, int moveFrameDelayMS, int frameWidth, int frameHeight) {
            this.idleFrames = idleFrames;
            this.idleFrameDelayMS = idleFrameDelayMS;
            this.movementFrames = movementFrames;
            this.moveFrameDelayMS = moveFrameDelayMS;
            this.frameWidth = frameWidth;
            this.frameHeight = frameHeight;
        }
    }
}

