/*
 * Decompiled with CFR 0.152.
 */
package group24.escaperoom.entities.properties;

import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.JsonValue;
import group24.escaperoom.entities.Item;
import group24.escaperoom.entities.properties.PhantomProperty;
import group24.escaperoom.entities.properties.PropertyDescription;
import group24.escaperoom.entities.properties.PropertyMap;
import group24.escaperoom.entities.properties.PropertyType;
import group24.escaperoom.ui.editor.PropertyConfiguration;
import group24.escaperoom.utils.Notifier;
import java.util.Optional;

public class AnimatedProperty
extends PhantomProperty {
    private static final PropertyDescription description = new PropertyDescription("Animated", "Change texture on fixed periods", "Animated items have a texture that is `N` item widths wide, where N is the number of frames in the animation and width is in pixels. Configure these parameters in the configuration menu", PropertyDescription.TEXTURE_CONFLICTS);
    private int numFrames;
    private int textureOffsetPerFrame;
    private float frameLength;
    private int width;
    private int height;
    private float lastUpdate = 0.0f;
    public static final int PIXELS_PER_WORLD_UNIT = 16;
    private int frameN = 0;

    @Override
    public PropertyDescription getDescription() {
        return description;
    }

    public AnimatedProperty(Item owner, int numFrames, float frameLength, int frameWidth, int frameHeight) {
        this.init(owner, numFrames, frameLength, frameWidth, frameHeight);
    }

    private void init(Item owner, int numFrames, float frameLength, int frameWidth, int frameHeight) {
        this.owner = owner;
        this.numFrames = numFrames;
        this.textureOffsetPerFrame = frameWidth;
        this.frameLength = frameLength;
        this.width = frameWidth;
        this.height = frameHeight;
        this.owner.adjustTextureRegion(0, 0, this.width, this.height);
    }

    public AnimatedProperty() {
    }

    public void maybeAdvance(float delta) {
        if (delta + this.lastUpdate > this.frameLength) {
            this.lastUpdate = 0.0f;
            ++this.frameN;
            this.frameN %= this.numFrames;
            this.updateTexture();
        } else {
            this.lastUpdate += delta;
        }
    }

    @Override
    public String getDisplayName() {
        return "Animated Property";
    }

    @Override
    public PropertyType getType() {
        return PropertyType.Animated;
    }

    public AnimatedProperty cloneProperty(Item newOwner) {
        return new AnimatedProperty(newOwner, this.numFrames, this.frameLength, this.width, this.height);
    }

    @Override
    public void updateTexture() {
        this.owner.adjustTextureRegion(this.frameN * this.textureOffsetPerFrame, 0, this.width, this.height);
    }

    @Override
    public void write(Json json) {
        json.writeValue("frame_count", this.numFrames);
        json.writeValue("frame_length", Float.valueOf(this.frameLength));
        json.writeValue("frame_width", this.width);
        json.writeValue("frame_height", this.height);
    }

    @Override
    public void read(Json json, JsonValue jsonData) {
        try {
            this.numFrames = jsonData.getInt("frame_count");
            this.frameLength = jsonData.getFloat("frame_length");
            this.width = jsonData.getInt("frame_width", this.owner.getWidth() * 16);
            this.height = jsonData.getInt("frame_height", this.owner.getHeight() * 16);
        }
        catch (IllegalArgumentException argE) {
            Notifier.error("Attempted to load Animated property without required\n'frame_count' and 'frame_length' property values");
            this.numFrames = 1;
            this.frameLength = 1000.0f;
            this.width = this.owner.getHeight() * 16;
            this.height = this.owner.getHeight() * 16;
            return;
        }
        this.textureOffsetPerFrame = this.width;
        PropertyMap.onMapCompletion.add(Void2 -> {
            this.owner.adjustTextureRegion(0, 0, this.width, this.height);
            return null;
        });
    }

    @Override
    public void apply(Item item) {
        super.apply(item);
        this.defaultConfiguration(item);
    }

    @Override
    public void defaultConfiguration(Item owner) {
        super.defaultConfiguration(owner);
        TextureAtlas.AtlasRegion region = owner.getTexture();
        int numFrames = Math.max(1, region.getRegionWidth() / (owner.getWidth() * 16));
        float frameLength = 0.5f;
        int frameWidth = Math.max(16, owner.getWidth() * 16);
        int frameHeight = Math.max(16, region.getRegionHeight());
        this.init(owner, numFrames, frameLength, frameWidth, frameHeight);
    }

    @Override
    public Optional<PropertyConfiguration> getCustomItemConfigurationMenu() {
        PropertyConfiguration config = new PropertyConfiguration();
        config.addNumberInput("Number of frames", null, new PropertyConfiguration.IntInput(this.numFrames, newVal -> {
            this.numFrames = newVal;
        }));
        config.addNumberInput("Frame length (ms)", null, new PropertyConfiguration.IntInput(MathUtils.floor(this.frameLength * 1000.0f), newVal -> {
            this.frameLength = (float)newVal / 1000.0f;
        }));
        config.addNumberInput("Frame width (px)", null, new PropertyConfiguration.IntInput(this.width, newVal -> {
            this.textureOffsetPerFrame = this.width = newVal;
            this.owner.adjustTextureRegion(0, 0, this.width, this.height);
        }));
        config.addNumberInput("Frame height (px)", null, new PropertyConfiguration.IntInput(this.height, newVal -> {
            this.height = newVal;
            this.owner.adjustTextureRegion(0, 0, this.width, this.height);
        }));
        return Optional.of(config);
    }
}

