/*
 * Decompiled with CFR 0.152.
 */
package group24.escaperoom.entities.properties;

import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.JsonValue;
import group24.escaperoom.entities.player.PlayerAction;
import group24.escaperoom.entities.properties.ItemProperty;
import group24.escaperoom.entities.properties.ItemPropertyValue;
import group24.escaperoom.ui.editor.Menu;

public abstract class BooleanProperty
extends ItemProperty<BooleanValue> {
    public boolean currentValue = false;

    @Override
    public void write(Json json) {
        json.writeValue("value", this.currentValue);
    }

    @Override
    public void read(Json json, JsonValue jsonData) {
        this.currentValue = jsonData.getBoolean("value", false);
    }

    @Override
    public Class<BooleanValue> getValueClass() {
        return BooleanValue.class;
    }

    @Override
    public Array<BooleanValue> getPotentialValues() {
        return Array.with(new BooleanValue(true), new BooleanValue(false));
    }

    @Override
    public void set(BooleanValue value) {
        this.currentValue = value.inner;
    }

    @Override
    public ItemProperty.MenuType getInputType() {
        return ItemProperty.MenuType.Toggleable;
    }

    @Override
    public BooleanValue getCurrentValue() {
        return new BooleanValue(this.currentValue);
    }

    @Override
    protected Array<PlayerAction> getAvailableActions() {
        return new Array<PlayerAction>();
    }

    public boolean isTrue() {
        return this.currentValue;
    }

    public static class BooleanValue
    implements ItemPropertyValue {
        boolean inner = false;

        public BooleanValue(boolean inner) {
            this.inner = inner;
        }

        public boolean isTrue() {
            return this.inner;
        }

        @Override
        public Menu.MenuEntry getDisplay(Menu parent) {
            return null;
        }
    }
}

