/*
 * Decompiled with CFR 0.152.
 */
package group24.escaperoom.entities.properties;

import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.JsonValue;
import group24.escaperoom.entities.Item;
import group24.escaperoom.entities.properties.PhantomProperty;
import group24.escaperoom.entities.properties.PropertyDescription;
import group24.escaperoom.entities.properties.PropertyType;
import group24.escaperoom.ui.editor.PropertyConfiguration;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;

public class Collideable
extends PhantomProperty {
    private static final PropertyDescription description = new PropertyDescription("Collidable", "Blocks player movement", "Collidable items block the player movement. This can be configured to be an area that is not equal to the items actual size.", new HashSet<PropertyType>(Set.of(PropertyType.Obtainable, PropertyType.Containable)));
    float dx;
    float dy;
    float width;
    float height;
    boolean wholeItem;

    @Override
    public PropertyDescription getDescription() {
        return description;
    }

    public Collideable() {
    }

    public Collideable(Item item, float dx, float dy, float width, float height) {
        this.owner = item;
        if (dx == 0.0f && dy == 0.0f && width == (float)item.getWidth() && height == (float)item.getHeight()) {
            this.wholeItem = true;
            item.setBlocksPlayer(true);
        } else {
            this.dx = dx;
            this.dy = dy;
            this.width = width;
            this.height = height;
            item.setBlocksPlayer(dx, dy, width, height);
        }
    }

    public Collideable(Item item) {
        this.owner = item;
        this.wholeItem = true;
        item.setBlocksPlayer(true);
    }

    @Override
    public String getDisplayName() {
        return "Collideable";
    }

    @Override
    public PropertyType getType() {
        return PropertyType.Collideable;
    }

    public Collideable cloneProperty(Item newOwner) {
        if (this.wholeItem) {
            return new Collideable(newOwner);
        }
        return new Collideable(newOwner, this.dx, this.dy, this.width, this.height);
    }

    @Override
    public void write(Json json) {
        json.writeValue("xoffset", Float.valueOf(this.dx));
        json.writeValue("yoffset", Float.valueOf(this.dy));
        json.writeValue("width", Float.valueOf(this.width));
        json.writeValue("height", Float.valueOf(this.height));
        json.writeValue("whole_item", this.wholeItem);
    }

    @Override
    public void read(Json json, JsonValue jsonData) {
        this.dx = jsonData.getFloat("xoffset", 0.0f);
        this.dy = jsonData.getFloat("yoffset", 0.0f);
        this.width = jsonData.getFloat("width", this.owner.getWidth());
        this.height = jsonData.getFloat("height", this.owner.getHeight());
        this.wholeItem = jsonData.getBoolean("whole_item", false);
        this.updateBlockingRegion();
    }

    private void updateBlockingRegion() {
        if (this.dx == 0.0f && this.dy == 0.0f && this.width == (float)this.owner.getWidth() && this.height == (float)this.owner.getHeight()) {
            this.wholeItem = true;
        }
        if (this.wholeItem) {
            this.owner.setBlocksPlayer(true);
        } else {
            this.owner.setBlocksPlayer(this.dx, this.dy, this.width, this.height);
        }
    }

    @Override
    public Optional<PropertyConfiguration> getCustomItemConfigurationMenu() {
        PropertyConfiguration config = new PropertyConfiguration();
        config.addNumberInput("Offset X", "Number of tiles in the positive X direction from the bottom left corner where the blocking region starts.", new PropertyConfiguration.FloatInput(this.dx, newVal -> {
            this.dx = newVal;
            this.updateBlockingRegion();
        }));
        config.addNumberInput("Offset Y", "Number of tiles in the positive Y direction from the bottom left corner where the blocking region starts.", new PropertyConfiguration.FloatInput(this.dy, newVal -> {
            this.dy = newVal;
            this.updateBlockingRegion();
        }));
        config.addNumberInput("Width", "Width of the blocking region in tiles", new PropertyConfiguration.FloatInput(this.width, newVal -> {
            this.width = newVal;
            this.updateBlockingRegion();
        }));
        config.addNumberInput("Height", "Height of the blocking region in tiles", new PropertyConfiguration.FloatInput(this.height, newVal -> {
            this.height = newVal;
            this.updateBlockingRegion();
        }));
        return Optional.of(config);
    }
}

