/*
 * Decompiled with CFR 0.152.
 */
package group24.escaperoom.entities.properties;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.JsonValue;
import group24.escaperoom.data.GameContext;
import group24.escaperoom.data.GameEvent;
import group24.escaperoom.data.GameEventBus;
import group24.escaperoom.entities.player.PlayerAction;
import group24.escaperoom.entities.properties.LockingMethod;
import group24.escaperoom.entities.properties.LockingMethodType;
import group24.escaperoom.entities.properties.StringItemPropertyValue;
import group24.escaperoom.screens.BackManager;
import group24.escaperoom.ui.GameDialog;
import group24.escaperoom.ui.editor.ConfigurationMenu;
import group24.escaperoom.ui.editor.Menu;
import group24.escaperoom.ui.widgets.G24NumberInput;
import group24.escaperoom.ui.widgets.G24TextButton;
import group24.escaperoom.ui.widgets.G24TextInput;

public class CombinationLock
extends LockingMethod
implements StringItemPropertyValue {
    public String combination = "1234";

    public CombinationLock() {
    }

    public CombinationLock(String val) {
        this.combination = val;
    }

    @Override
    public String getValue() {
        return this.combination;
    }

    @Override
    public void setValue(String value) {
        this.combination = value;
    }

    @Override
    public boolean isLocked() {
        return this.isLocked;
    }

    @Override
    public Menu.MenuEntry getDisplay(Menu parent) {
        return new Menu.MenuEntryBuilder(parent, this.getName()).spawns(e -> new ConfigurationMenu<NumberInput>(e, this.configurationDisplay(), "Combination", parent.getScreen())).build();
    }

    public NumberInput configurationDisplay() {
        final NumberInput input = new NumberInput(this.combination);
        input.setMaxLength(8);
        input.setWidth(100.0f);
        input.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                CombinationLock.this.combination = input.getText();
            }
        });
        return input;
    }

    @Override
    public String getName() {
        return "Combination Lock";
    }

    @Override
    public Array<PlayerAction> getActions() {
        return Array.with(new TryUnlock());
    }

    @Override
    public void write(Json json) {
        super.write(json);
        json.writeValue("combo", this.combination);
    }

    @Override
    public void read(Json json, JsonValue data) {
        super.read(json, data);
        this.combination = data.getString("combo", "1234");
    }

    @Override
    public LockingMethodType getType() {
        return LockingMethodType.CombinationLock;
    }

    @Override
    protected LockingMethod getEmptyMethod() {
        return new CombinationLock();
    }

    @Override
    protected PlayerAction maybeGetLockAction() {
        return null;
    }

    @Override
    protected PlayerAction maybeGetUnlockAction() {
        return new TryUnlock();
    }

    private class NumberInput
    extends G24NumberInput
    implements ConfigurationMenu.HandlesMenuClose {
        NumberInput(String s) {
            super(s);
        }

        @Override
        public void handle() {
        }
    }

    protected class TryUnlock
    implements PlayerAction {
        protected TryUnlock() {
        }

        @Override
        public String getActionName() {
            return "Enter combination";
        }

        @Override
        public PlayerAction.ActionResult act(final GameContext ctx) {
            if (ctx.player == null) {
                return PlayerAction.ActionResult.DEFAULT;
            }
            final GameDialog dialog = new GameDialog(ctx.player, "Enter Combination");
            Table table = new Table();
            final G24NumberInput[] digits = new G24NumberInput[CombinationLock.this.combination.length()];
            for (int i = 0; i < CombinationLock.this.combination.length(); ++i) {
                G24NumberInput input = new G24NumberInput();
                input.enableAutoFocusTraversal();
                input.setMessageText("0");
                input.setMaxLength(1);
                digits[i] = input;
            }
            final G24TextButton submitButton = new G24TextButton("Try Unlock");
            submitButton.setProgrammaticChangeEvents(false);
            submitButton.addListener(new ChangeListener(){

                @Override
                public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                    if (submitButton.isPressed()) {
                        String result = new String();
                        for (G24NumberInput input : digits) {
                            result = result + input.getText();
                        }
                        if (result.equals(CombinationLock.this.combination)) {
                            CombinationLock.this.isLocked = false;
                            if (CombinationLock.this.isBarrier) {
                                CombinationLock.this.owner.ifPresent(i -> {
                                    i.setBlocksPlayer(false);
                                    i.setAlpha(0.5f);
                                });
                            }
                            submitButton.setDisabled(true);
                            dialog.hide();
                            CombinationLock.this.owner.ifPresent(i -> GameEventBus.get().post(new GameEvent.Builder(GameEvent.EventType.ItemStateChange, ctx).message(i.getItemName() + " clicked open...").build()));
                            if (actor.getStage().getKeyboardFocus() instanceof G24TextInput) {
                                BackManager.goBack();
                            }
                            BackManager.goBack();
                        } else {
                            CombinationLock.this.owner.ifPresent(i -> GameEventBus.get().post(new GameEvent.Builder(GameEvent.EventType.ItemStateChange, ctx).message(i.getItemName() + " won't budge...").build()));
                        }
                    }
                    submitButton.setChecked(false);
                }
            });
            table.defaults().pad(0.0f).center();
            for (G24NumberInput input : digits) {
                table.add(input).maxWidth(20.0f).minWidth(0.0f);
            }
            table.row();
            table.add(submitButton).align(1).colspan(digits.length);
            table.row();
            dialog.setContent(table);
            return new PlayerAction.ActionResult().showsDialog(dialog);
        }

        @Override
        public boolean isValid(GameContext ctx) {
            return CombinationLock.this.isLocked();
        }
    }
}

