/*
 * Decompiled with CFR 0.152.
 */
package group24.escaperoom.entities.properties;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.utils.Array;
import group24.escaperoom.data.GameContext;
import group24.escaperoom.entities.player.PlayerAction;
import group24.escaperoom.entities.properties.PhantomProperty;
import group24.escaperoom.entities.properties.PropertyDescription;
import group24.escaperoom.entities.properties.PropertyType;
import group24.escaperoom.screens.SinglePlayerGameScreen;
import group24.escaperoom.ui.GameDialog;
import group24.escaperoom.ui.widgets.G24TextButton;

public class CompletesLevel
extends PhantomProperty {
    private static final PropertyDescription description = new PropertyDescription("Completes level", "Provides game ending action", "Completes level items provide the special player action \"Claim your victory\"", null);

    @Override
    public PropertyDescription getDescription() {
        return description;
    }

    @Override
    public Array<PlayerAction> getAvailableActions() {
        return Array.with(new WinAction());
    }

    @Override
    public String getDisplayName() {
        return "Completes Level";
    }

    @Override
    public PropertyType getType() {
        return PropertyType.CompletesLevel;
    }

    public class WinAction
    implements PlayerAction {
        @Override
        public String getActionName() {
            return "Complete Level";
        }

        @Override
        public PlayerAction.ActionResult act(GameContext ctx) {
            G24TextButton winButton = new G24TextButton("Claim your victory");
            winButton.addListener(new ChangeListener(){

                @Override
                public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                    SinglePlayerGameScreen screen = (SinglePlayerGameScreen)CompletesLevel.this.owner.map;
                    screen.completeLevel(true);
                }
            });
            return new PlayerAction.ActionResult().showsDialog(new GameDialog((Actor)winButton, ctx.player, "Congratulations!"));
        }

        @Override
        public boolean isValid(GameContext ctx) {
            return true;
        }
    }
}

