/*
 * Decompiled with CFR 0.152.
 */
package group24.escaperoom.entities.properties;

import group24.escaperoom.data.GameContext;
import group24.escaperoom.entities.properties.PropertyDescription;
import group24.escaperoom.entities.properties.PropertyType;
import group24.escaperoom.entities.properties.conditionals.ConditionalProperty;
import group24.escaperoom.screens.SinglePlayerGameScreen;

public class ConditionallyVisible
extends ConditionalProperty {
    private static final PropertyDescription description = new PropertyDescription("Conditionally Visible", "Is visible only under some condition", "Conditionally visible items only appear on the map when some condition is met", null);

    @Override
    public PropertyDescription getDescription() {
        return description;
    }

    @Override
    public String getDisplayName() {
        return "Visible When...";
    }

    @Override
    public boolean requiresPoll() {
        return true;
    }

    @Override
    public boolean poll(GameContext ctx) {
        this.condition.poll(ctx);
        boolean valid = this.isValid(ctx);
        if (this.owner.hasProperty(PropertyType.Player) && this.owner.map instanceof SinglePlayerGameScreen) {
            SinglePlayerGameScreen game = (SinglePlayerGameScreen)this.owner.map;
            if (valid && this.owner.id != game.playerId) {
                ctx.map.placeItem(this.owner);
                game.loadPlayer();
                return false;
            }
            this.owner.remove(false);
            return true;
        }
        if (valid && !this.owner.isContained()) {
            ctx.map.placeItem(this.owner);
            return false;
        }
        this.owner.remove(false);
        return true;
    }

    @Override
    public PropertyType getType() {
        return PropertyType.ConditionallyVisible;
    }
}

