/*
 * Decompiled with CFR 0.152.
 */
package group24.escaperoom.entities.properties;

import group24.escaperoom.data.GameContext;
import group24.escaperoom.data.Types;
import group24.escaperoom.entities.Item;
import group24.escaperoom.entities.properties.Connector;
import group24.escaperoom.entities.properties.ConnectorBridge;
import group24.escaperoom.entities.properties.ConnectorRelay;
import group24.escaperoom.entities.properties.ConnectorSink;
import group24.escaperoom.entities.properties.ConnectorSource;
import group24.escaperoom.entities.properties.ItemProperty;
import group24.escaperoom.entities.properties.ItemPropertyValue;
import group24.escaperoom.entities.properties.PropertyType;
import group24.escaperoom.entities.properties.TiledBrushable;
import group24.escaperoom.screens.MapScreen;
import group24.escaperoom.ui.editorTools.TiledBrush;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;

public interface Connectable {
    public static final Types.IntVector2[] defaultConnectionDirections = new Types.IntVector2[]{new Types.IntVector2(-1, 1), new Types.IntVector2(0, 1), new Types.IntVector2(1, 1), new Types.IntVector2(-1, 0), new Types.IntVector2(1, 0), new Types.IntVector2(-1, -1), new Types.IntVector2(0, -1), new Types.IntVector2(1, -1)};

    public void propagate(GameContext var1, HashSet<Integer> var2);

    default public Types.IntVector2[] connectionDirections() {
        return defaultConnectionDirections;
    }

    public void acceptSignalFrom(Connectable var1, Types.IntVector2 var2, GameContext var3, HashSet<Integer> var4);

    public void setActive(boolean var1, GameContext var2);

    public Connector.ConnectorType getConnectorType();

    public boolean isConnected();

    public static final class Utils {
        public static Optional<ConnectableItem> isConnectable(Item i) {
            for (Connector.ConnectorType t : Connector.ConnectorType.values()) {
                Optional<ConnectableItem> ci = Utils.matches(i, t);
                if (!ci.isPresent()) continue;
                return ci;
            }
            return Optional.empty();
        }

        private static <T extends ItemPropertyValue, P extends ItemProperty<T>> Optional<ConnectableItem> tryGet(Item i, PropertyType propertyType, Class<P> expectedClass, Connector.ConnectorType connectorType) {
            try {
                Optional<Connectable> oC = i.getProperty(propertyType, expectedClass).map(c -> (Connectable)((Object)c));
                if (oC.isPresent() && oC.get().getConnectorType() == connectorType) {
                    return Optional.of(new ConnectableItem(i, oC.get()));
                }
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
            return Optional.empty();
        }

        public static Optional<ConnectableItem> matches(Item i, Connector.ConnectorType connectorType) {
            Optional<Object> oCI = Optional.empty();
            oCI = Utils.tryGet(i, PropertyType.Connector, Connector.class, connectorType);
            if (oCI.isPresent()) {
                return oCI;
            }
            oCI = Utils.tryGet(i, PropertyType.ConnectorSource, ConnectorSource.class, connectorType);
            if (oCI.isPresent()) {
                return oCI;
            }
            oCI = Utils.tryGet(i, PropertyType.ConnectorRelay, ConnectorRelay.class, connectorType);
            if (oCI.isPresent()) {
                return oCI;
            }
            oCI = Utils.tryGet(i, PropertyType.ConnectorSink, ConnectorSink.class, connectorType);
            if (oCI.isPresent()) {
                return oCI;
            }
            oCI = Utils.tryGet(i, PropertyType.ConnectorBridge, ConnectorBridge.class, connectorType);
            if (oCI.isPresent()) {
                return oCI;
            }
            return Optional.empty();
        }

        public static Optional<ConnectableItem> connectableAt(Types.IntVector2 pos, MapScreen screen, Connector.ConnectorType type) {
            return screen.getItemsAt(pos.x, pos.y).flatMap(items -> {
                for (int i = 0; i < ((Item[])items).length; ++i) {
                    Optional<ConnectableItem> oCI = Utils.matches(items[i], type);
                    if (!oCI.isPresent()) continue;
                    return oCI;
                }
                return Optional.empty();
            });
        }

        public static void maybeUpateSurroundingTileables(Item justPlaced, MapScreen screen) {
            Utils.isConnectable(justPlaced).ifPresent(ci -> ci.item.getProperty(PropertyType.TiledBrushable, TiledBrushable.class).ifPresentOrElse(__ -> {}, () -> {
                Types.IntVector2[] updatePositions;
                for (Types.IntVector2 updatePos : updatePositions = ci.connectable.connectionDirections()) {
                    screen.getItemsAt(justPlaced.getX() + updatePos.x, justPlaced.getY() + updatePos.y).ifPresent(items -> Arrays.stream(items).forEach(item -> Utils.isConnectable(item).ifPresent(ci2 -> {
                        if (ci2.connectable.getConnectorType() == ci.connectable.getConnectorType()) {
                            ci2.item.getProperty(PropertyType.TiledBrushable, TiledBrushable.class).ifPresent(tbp -> TiledBrush.updateTiles(ci2.item.getPosition(), screen, ci2.item, false));
                        }
                    })));
                }
            }));
        }
    }

    public static final class ConnectableItem {
        public final Item item;
        public final Connectable connectable;

        public ConnectableItem(Item item, Connectable connectable) {
            this.item = item;
            this.connectable = connectable;
        }
    }
}

