/*
 * Decompiled with CFR 0.152.
 */
package group24.escaperoom.entities.properties;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.JsonValue;
import group24.escaperoom.data.GameContext;
import group24.escaperoom.data.Types;
import group24.escaperoom.entities.properties.Connectable;
import group24.escaperoom.entities.properties.PhantomProperty;
import group24.escaperoom.entities.properties.PropertyDescription;
import group24.escaperoom.entities.properties.PropertyType;
import group24.escaperoom.ui.editor.PropertyConfiguration;
import java.util.HashSet;
import java.util.Optional;

public class Connector
extends PhantomProperty
implements Connectable {
    private static final PropertyDescription description = new PropertyDescription("Connector", "Transmits signals", "Connector items can have different types, and propagate signals to other connectors of their same types.", PropertyDescription.CONNECTOR_CONFLICTS);
    protected ConnectorType type = ConnectorType.Power;
    protected boolean connected;
    private Color connectedColor = new Color(0.75f, 1.0f, 0.75f, 1.0f);
    private Color disconnectedColor = new Color(1.0f, 0.75f, 0.75f, 1.0f);

    @Override
    public PropertyDescription getDescription() {
        return description;
    }

    @Override
    public ConnectorType getConnectorType() {
        return this.type;
    }

    @Override
    public void propagate(GameContext ctx, HashSet<Integer> seen) {
        if (seen.contains(this.owner.getID())) {
            return;
        }
        seen.add(this.owner.getID());
        Types.IntVector2 position = this.owner.getPosition();
        for (int yoff = 1; yoff >= -1; --yoff) {
            for (int xoff = -1; xoff <= 1; ++xoff) {
                if (Math.abs(xoff) == Math.abs(yoff)) continue;
                Types.IntVector2 pos = position.cpy();
                pos.x += xoff;
                pos.y += yoff;
                Connectable.Utils.connectableAt(pos, ctx.map, this.type).ifPresent(ci -> ci.connectable.acceptSignalFrom(this, position, ctx, seen));
            }
        }
    }

    @Override
    public void setActive(boolean connected, GameContext ctx) {
        this.connected = connected;
        this.propagate(ctx, new HashSet<Integer>());
    }

    @Override
    public boolean isConnected() {
        return this.connected;
    }

    @Override
    public String getDisplayName() {
        return "Connector";
    }

    @Override
    public PropertyType getType() {
        return PropertyType.Connector;
    }

    @Override
    public void write(Json json) {
        json.writeValue("type", this.type.name());
    }

    @Override
    public void read(Json json, JsonValue jsonData) {
        this.type = ConnectorType.valueOf(jsonData.getString("type"));
    }

    protected void updateColor() {
        if (this.connected) {
            this.owner.setColor(this.connectedColor);
        } else {
            this.owner.setColor(this.disconnectedColor);
        }
    }

    @Override
    public void acceptSignalFrom(Connectable source, Types.IntVector2 position, GameContext ctx, HashSet<Integer> seen) {
        if (source.getConnectorType() != this.type) {
            return;
        }
        this.connected = source.isConnected();
        this.updateColor();
        this.propagate(ctx, seen);
    }

    @Override
    public Optional<PropertyConfiguration> getCustomItemConfigurationMenu() {
        PropertyConfiguration config = new PropertyConfiguration();
        config.addSelect("Connector Type", "", new PropertyConfiguration.Select<ConnectorType>(val -> {
            this.type = (ConnectorType)((Object)((Object)val));
        }, val -> {}, ConnectorType.values(), val -> ((ConnectorType)((Object)((Object)val))).name(), 1, this.type));
        return Optional.of(config);
    }

    public static enum ConnectorType {
        Power,
        Magic,
        Juice;

    }
}

