/*
 * Decompiled with CFR 0.152.
 */
package group24.escaperoom.entities.properties;

import group24.escaperoom.data.GameContext;
import group24.escaperoom.data.Types;
import group24.escaperoom.entities.properties.Connectable;
import group24.escaperoom.entities.properties.Connector;
import group24.escaperoom.entities.properties.PropertyDescription;
import group24.escaperoom.entities.properties.PropertyType;
import java.util.HashSet;

public class ConnectorBridge
extends Connector {
    private static final PropertyDescription description = new PropertyDescription("Connector Bridge", "Propagates signals", "Connector items can have different types, and propagate signals to other connectors of their same types.", PropertyDescription.CONNECTOR_CONFLICTS);

    @Override
    public PropertyDescription getDescription() {
        return description;
    }

    Types.IntVector2 output(int rotation) {
        switch (rotation) {
            case 0: {
                return new Types.IntVector2(3, 0);
            }
            case 90: {
                return new Types.IntVector2(0, 3);
            }
            case 180: {
                return new Types.IntVector2(-1, 0);
            }
            case 270: {
                return new Types.IntVector2(0, -1);
            }
        }
        return null;
    }

    Types.IntVector2 input(int rotation) {
        switch (rotation) {
            case 0: {
                return new Types.IntVector2(-1, 0);
            }
            case 90: {
                return new Types.IntVector2(0, -1);
            }
            case 180: {
                return new Types.IntVector2(3, 0);
            }
            case 270: {
                return new Types.IntVector2(0, 3);
            }
        }
        return null;
    }

    @Override
    public Types.IntVector2[] connectionDirections() {
        return new Types.IntVector2[0];
    }

    @Override
    public void acceptSignalFrom(Connectable source, Types.IntVector2 pos, GameContext ctx, HashSet<Integer> seen) {
        Types.IntVector2 position = this.owner.getPosition();
        Types.IntVector2 input = this.input(this.owner.getRotation());
        Types.IntVector2 cpy = position.cpy();
        cpy.x += input.x;
        cpy.y += input.y;
        if (cpy.equals(pos)) {
            this.connected = source.isConnected();
            this.updateColor();
            this.propagate(ctx, seen);
            return;
        }
    }

    @Override
    public void propagate(GameContext ctx, HashSet<Integer> seen) {
        if (seen.contains(this.owner.getID())) {
            return;
        }
        seen.add(this.owner.getID());
        Types.IntVector2 position = this.owner.getPosition();
        Types.IntVector2 output = this.output(this.owner.getRotation());
        Types.IntVector2 pos = position.cpy();
        pos.y += output.y;
        pos.x += output.x;
        Connectable.Utils.connectableAt(pos, ctx.map, this.type).ifPresent(ci -> ci.connectable.acceptSignalFrom(this, position, ctx, seen));
    }

    @Override
    public PropertyType getType() {
        return PropertyType.ConnectorBridge;
    }
}

