/*
 * Decompiled with CFR 0.152.
 */
package group24.escaperoom.entities.properties;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.HorizontalGroup;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.JsonValue;
import group24.escaperoom.data.GameContext;
import group24.escaperoom.data.Types;
import group24.escaperoom.entities.properties.Connectable;
import group24.escaperoom.entities.properties.Connector;
import group24.escaperoom.entities.properties.ItemProperty;
import group24.escaperoom.entities.properties.PhantomProperty;
import group24.escaperoom.entities.properties.PropertyDescription;
import group24.escaperoom.entities.properties.PropertyType;
import group24.escaperoom.entities.properties.StringItemPropertyValue;
import group24.escaperoom.screens.LevelEditorScreen;
import group24.escaperoom.ui.SimpleUI;
import group24.escaperoom.ui.SmallLabel;
import group24.escaperoom.ui.editor.ConfigurationMenu;
import group24.escaperoom.ui.editor.Menu;
import group24.escaperoom.ui.editor.PropertyConfiguration;
import group24.escaperoom.ui.widgets.G24NumberInput;
import java.util.HashSet;
import java.util.Optional;
import java.util.function.Function;

public class ConnectorRelay
extends Connector {
    private static final PropertyDescription description = new PropertyDescription("Connector Relay", "Transforms signals", "Connector items can have different types, and propagate signals to other connectors of their same types.", PropertyDescription.CONNECTOR_CONFLICTS);
    private RelayType relayType = RelayType.And;
    private RelayContext rlyCtx = new RelayContext();

    @Override
    public PropertyDescription getDescription() {
        return description;
    }

    @Override
    public ItemProperty.MenuType getInputType() {
        switch (this.relayType) {
            case Buffer: 
            case Filter: 
            case Clock: {
                return ItemProperty.MenuType.PopOut;
            }
        }
        return ItemProperty.MenuType.None;
    }

    @Override
    public void propagate(GameContext ctx, HashSet<Integer> seen) {
        this.updateInputs(ctx);
        this.rlyCtx = this.relayType.update(this.rlyCtx);
        this.connected = this.rlyCtx.output;
        this.updateColor();
        Types.IntVector2 position = this.owner.getPosition();
        Direction outputDirs = this.relayType.output().adjust(this.owner.getRotation());
        Types.IntVector2 pos = position.cpy();
        pos.x += outputDirs.offsetX;
        pos.y += outputDirs.offsetY;
        Connectable.Utils.connectableAt(pos, ctx.map, this.type).ifPresent(i -> {
            if (!seen.contains(i.item.getID())) {
                i.connectable.acceptSignalFrom(this, position, ctx, seen);
            }
        });
    }

    @Override
    public Types.IntVector2[] connectionDirections() {
        Direction d = this.relayType.output().adjust(this.owner.getRotation());
        Types.IntVector2 outputVec = new Types.IntVector2(d.offsetX, d.offsetY);
        d = this.relayType.input1().adjust(this.owner.getRotation());
        Types.IntVector2 input1 = new Types.IntVector2(d.offsetX, d.offsetY);
        Optional<Direction> oD = this.relayType.input2().map(dir -> dir.adjust(this.owner.getRotation()));
        if (oD.isPresent()) {
            Types.IntVector2[] ret = new Types.IntVector2[]{outputVec, input1, new Types.IntVector2(oD.get().offsetX, oD.get().offsetY)};
            return ret;
        }
        Types.IntVector2[] ret = new Types.IntVector2[]{outputVec, input1};
        return ret;
    }

    @Override
    public boolean isConnected() {
        return this.connected;
    }

    public void updateInputs(GameContext ctx) {
        Types.IntVector2 position = this.owner.getPosition();
        Direction input1Dir = this.relayType.input1().adjust(this.owner.getRotation());
        Types.IntVector2 cpy = position.cpy();
        cpy.x += input1Dir.offsetX;
        cpy.y += input1Dir.offsetY;
        Connectable.Utils.connectableAt(cpy, ctx.map, this.getConnectorType()).ifPresent(c -> {
            this.rlyCtx.input1 = c.connectable.isConnected();
        });
        this.relayType.input2().ifPresent(i2 -> {
            Direction input2 = i2.adjust(this.owner.getRotation());
            Types.IntVector2 cpy2 = position.cpy();
            cpy2.x += input2.offsetX;
            cpy2.y += input2.offsetY;
            Connectable.Utils.connectableAt(cpy2, ctx.map, this.getConnectorType()).ifPresent(c -> {
                this.rlyCtx.input2 = c.connectable.isConnected();
            });
        });
    }

    @Override
    public void acceptSignalFrom(Connectable source, Types.IntVector2 pos, GameContext ctx, HashSet<Integer> seen) {
        Types.IntVector2 position = this.owner.getPosition();
        Direction input1Dir = this.relayType.input1().adjust(this.owner.getRotation());
        Types.IntVector2 cpy = position.cpy();
        cpy.x += input1Dir.offsetX;
        cpy.y += input1Dir.offsetY;
        if (cpy.equals(pos)) {
            this.rlyCtx.input1 = source.isConnected();
            this.rlyCtx = this.relayType.update(this.rlyCtx);
            this.connected = this.rlyCtx.output;
            this.updateColor();
            this.propagate(ctx, seen);
            return;
        }
        this.relayType.input2().ifPresent(i2 -> {
            Direction input2 = i2.adjust(this.owner.getRotation());
            Types.IntVector2 cpy2 = position.cpy();
            cpy2.x += input2.offsetX;
            cpy2.y += input2.offsetY;
            if (cpy2.equals(pos)) {
                this.rlyCtx.input2 = source.isConnected();
                this.rlyCtx = this.relayType.update(this.rlyCtx);
                this.connected = this.rlyCtx.output;
                this.updateColor();
                this.propagate(ctx, seen);
            }
        });
    }

    @Override
    public void setActive(boolean connected, GameContext ctx) {
        this.connected = connected;
        this.propagate(ctx, new HashSet<Integer>());
    }

    @Override
    public String getDisplayName() {
        return "Relay (" + this.type.name() + "): " + this.relayType.name();
    }

    @Override
    public ConfigurationMenu<SimpleUI> getPopOut(Menu.MenuEntry parent) {
        LevelEditorScreen screen = (LevelEditorScreen)parent.getScreen();
        final StringItemPropertyValue contents = (StringItemPropertyValue)((Object)this.getCurrentValue());
        final G24NumberInput textField = new G24NumberInput(contents.getValue());
        textField.setMaxLength(200);
        HorizontalGroup row = new HorizontalGroup();
        row.space(10.0f);
        row.addActor(new SmallLabel(this.getDisplayName() + ":"));
        textField.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                contents.setValue(textField.getText());
            }
        });
        textField.pack();
        row.addActor(textField);
        return new ConfigurationMenu<SimpleUI>(parent, new SimpleUI((Actor)row), "Connector", screen);
    }

    @Override
    public PropertyType getType() {
        return PropertyType.ConnectorRelay;
    }

    @Override
    public void write(Json json) {
        super.write(json);
        json.writeValue("relay_type", this.relayType.name());
        json.writeValue("delay", this.rlyCtx.number);
    }

    @Override
    public void read(Json json, JsonValue jsonData) {
        super.read(json, jsonData);
        this.relayType = RelayType.valueOf(jsonData.getString("relay_type"));
        this.rlyCtx.number = jsonData.getInt("delay", 500);
    }

    @Override
    public PhantomProperty.PhantomPropertyValue getCurrentValue() {
        return this.rlyCtx;
    }

    @Override
    public Optional<PropertyConfiguration> getCustomItemConfigurationMenu() {
        PropertyConfiguration config = super.getCustomItemConfigurationMenu().get();
        config.addSelect("Relay type", null, new PropertyConfiguration.Select<RelayType>(val -> {
            this.relayType = (RelayType)((Object)((Object)val));
        }, val -> {}, RelayType.values(), val -> ((RelayType)((Object)((Object)val))).name(), 1, this.relayType));
        return Optional.of(config);
    }

    public static enum RelayType {
        And(ctx -> {
            ctx.output = ctx.input1 != false && ctx.input2 != false;
            return ctx;
        }),
        Clock(ctx -> {
            final class 1TimerState {
                long last = -1L;
                long period = 500L;

                1TimerState(int period) {
                    this.period = period;
                }
            }
            if (ctx.state == null) {
                ctx.state = new 1TimerState(ctx.number);
            }
            1TimerState ts = (1TimerState)ctx.state;
            long now = System.currentTimeMillis();
            if (ts.last < 0L) {
                ts.last = now;
                ctx.output = false;
            }
            if (now - ts.last >= ts.period) {
                ctx.output = ctx.output == false;
                ts.last = now;
            }
            return ctx;
        }),
        Nand(ctx -> {
            ctx.output = ctx.input1 == false || ctx.input2 == false;
            return ctx;
        }),
        Or(ctx -> {
            ctx.output = ctx.input1 != false || ctx.input2 != false;
            return ctx;
        }),
        Xor(ctx -> {
            ctx.output = ctx.input1 ^ ctx.input2;
            return ctx;
        }),
        Buffer(ctx -> {
            final class 2TimerState {
                Long time = -1L;
                int state;

                2TimerState() {
                }
            }
            if (ctx.state == null) {
                ctx.state = new 2TimerState();
            }
            2TimerState ts = (2TimerState)ctx.state;
            if (ctx.input1.booleanValue()) {
                ctx.output = true;
                ts.time = -1L;
                ts.state = 0;
            } else {
                switch (ts.state) {
                    case 0: {
                        ts.time = System.currentTimeMillis();
                        ts.state = 1;
                        break;
                    }
                    case 1: {
                        if (System.currentTimeMillis() <= ts.time + (long)ctx.number) break;
                        ctx.output = false;
                        ts.state = 2;
                        break;
                    }
                    case 2: {
                        ctx.output = false;
                    }
                }
            }
            return ctx;
        }),
        Filter(ctx -> {
            final class 3TimerState {
                Long time = -1L;
                int state = 0;

                3TimerState() {
                }
            }
            if (ctx.state == null) {
                ctx.state = new 3TimerState();
            }
            3TimerState ts = (3TimerState)ctx.state;
            if (ctx.input1.booleanValue()) {
                switch (ts.state) {
                    case 0: {
                        ts.time = System.currentTimeMillis();
                        ts.state = 1;
                        break;
                    }
                    case 1: {
                        if (System.currentTimeMillis() <= ts.time + (long)ctx.number) break;
                        ts.time = -1L;
                        ts.state = 2;
                        ctx.output = true;
                        break;
                    }
                    case 2: {
                        ctx.output = true;
                    }
                }
            } else {
                ts.state = 0;
                ts.time = -1L;
                ctx.output = false;
            }
            return ctx;
        }),
        SRLatch(ctx -> {
            if (ctx.input1.booleanValue()) {
                ctx.stored = true;
            }
            if (ctx.input2.booleanValue()) {
                ctx.stored = false;
            }
            ctx.output = ctx.stored;
            return ctx;
        }),
        Not(ctx -> {
            ctx.output = ctx.input1 == false;
            return ctx;
        });

        private Function<RelayContext, RelayContext> func2;

        private RelayType(Function<RelayContext, RelayContext> apply) {
            this.func2 = apply;
        }

        public RelayContext update(RelayContext ctx) {
            return this.func2.apply(ctx);
        }

        public Direction output() {
            return Direction.NORTH;
        }

        public Direction input1() {
            switch (this) {
                case Or: 
                case And: 
                case SRLatch: 
                case Xor: 
                case Nand: {
                    return Direction.EAST;
                }
                case Buffer: 
                case Filter: 
                case Clock: 
                case Not: {
                    return Direction.SOUTH;
                }
            }
            return null;
        }

        public Optional<Direction> input2() {
            switch (this) {
                case Or: 
                case And: 
                case SRLatch: 
                case Xor: 
                case Nand: {
                    return Optional.of(Direction.WEST);
                }
                case Buffer: 
                case Filter: 
                case Clock: 
                case Not: {
                    return Optional.empty();
                }
            }
            return null;
        }
    }

    private static class RelayContext
    extends PhantomProperty.PhantomPropertyValue
    implements StringItemPropertyValue {
        Boolean output = false;
        Boolean input1 = false;
        Boolean input2 = false;
        Boolean stored = false;
        int number = 500;
        Object state = null;

        private RelayContext() {
        }

        @Override
        public String getValue() {
            return Integer.toString(this.number);
        }

        @Override
        public void setValue(String value) {
            try {
                this.number = Integer.parseInt(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public static enum Direction {
        NORTH(0, 1, 0),
        SOUTH(0, -1, 2),
        EAST(1, 0, 1),
        WEST(-1, 0, 3);

        public final int offsetX;
        public final int offsetY;
        public final int pos;
        private static final Direction[] dirs;

        private Direction(int offX, int offY, int pos) {
            this.offsetX = offX;
            this.offsetY = offY;
            this.pos = pos;
        }

        Direction adjust(int rotation) {
            int count = Math.abs(rotation / 90);
            int newInd = (this.pos + count) % 4;
            return dirs[newInd];
        }

        static {
            dirs = new Direction[]{NORTH, EAST, SOUTH, WEST};
        }
    }
}

