/*
 * Decompiled with CFR 0.152.
 */
package group24.escaperoom.entities.properties;

import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.JsonValue;
import group24.escaperoom.data.GameContext;
import group24.escaperoom.data.Types;
import group24.escaperoom.entities.properties.Connectable;
import group24.escaperoom.entities.properties.Connector;
import group24.escaperoom.entities.properties.PropertyDescription;
import group24.escaperoom.entities.properties.PropertyType;
import group24.escaperoom.ui.editor.PropertyConfiguration;
import java.util.HashSet;
import java.util.Optional;

public class ConnectorSource
extends Connector {
    boolean alwaysOn = true;
    private static final PropertyDescription description = new PropertyDescription("Connector Source", "Creates signals", "Connector sources propagates signals to other connectors with their same type.\nConnector sources do not accept signals! If combined with Toggleable, this source will only propagate signals when it is toggled on.", PropertyDescription.CONNECTOR_CONFLICTS);

    @Override
    public PropertyDescription getDescription() {
        return description;
    }

    @Override
    public PropertyType getType() {
        return PropertyType.ConnectorSource;
    }

    @Override
    public String getDisplayName() {
        return "ConnectorSource";
    }

    @Override
    public void propagate(GameContext ctx, HashSet<Integer> seen) {
        if (seen.contains(this.owner.getID())) {
            return;
        }
        seen.add(this.owner.getID());
        Types.IntVector2 position = this.owner.getPosition();
        for (int yoff = 1; yoff >= -1; --yoff) {
            for (int xoff = -1; xoff <= 1; ++xoff) {
                if (Math.abs(xoff) == Math.abs(yoff)) continue;
                Types.IntVector2 pos = position.cpy();
                pos.x += xoff;
                pos.y += yoff;
                Connectable.Utils.connectableAt(pos, ctx.map, this.type).ifPresent(i -> i.connectable.acceptSignalFrom(this, position, ctx, seen));
            }
        }
    }

    @Override
    public void setActive(boolean connected, GameContext ctx) {
        if (connected != this.connected) {
            this.connected = connected;
            this.propagate(ctx, new HashSet<Integer>());
        }
        if (this.alwaysOn) {
            this.connected = true;
            this.updateColor();
        }
    }

    @Override
    public Connector.ConnectorType getConnectorType() {
        return Connector.ConnectorType.Power;
    }

    @Override
    public void acceptSignalFrom(Connectable source, Types.IntVector2 position, GameContext ctx, HashSet<Integer> seen) {
    }

    @Override
    public void write(Json json) {
        super.write(json);
        json.writeValue("connected", this.alwaysOn);
    }

    @Override
    public Optional<PropertyConfiguration> getCustomItemConfigurationMenu() {
        PropertyConfiguration config = super.getCustomItemConfigurationMenu().get();
        config.addToggle("Always on", "Whether or not this source always propagates a positive signal", this.alwaysOn, isToggled -> {
            this.alwaysOn = isToggled;
        });
        return Optional.of(config);
    }

    @Override
    public void read(Json json, JsonValue jsonData) {
        super.read(json, jsonData);
        this.alwaysOn = jsonData.getBoolean("connected", false);
        if (this.alwaysOn) {
            this.connected = true;
            this.updateColor();
        }
    }
}

